define('branchinator/views/layout/content-view', [
    'branchinator/collections/recent-branches-collection',
    'branchinator/utils/radio-utils',
    'branchinator/views/layout/content/builds-view',
    'branchinator/views/layout/content/integrations-view',
    'branchinator/views/layout/content/landing-page-view',
    'jquery',
    'marionette'
], function(
    RecentBranchesCollection,
    radioUtils,
    BuildsView,
    IntegrationsView,
    LandingPageView,
    $,
    Marionette
) {
    'use strict';

    /**
     * Main content of the branch status page. Incorporates landing page and builds table, as well as widget for adding
     * new plan branches.
     *
     * Parameters:
     * - model - branch selection model
     */
    return Marionette.LayoutView.extend({
        regions: {
            landingPage: '#landingPageContainer',
            builds: '#buildsContainer',
            integrations: '#integrationsContainer'
        },

        modelEvents: {
            'repo:cleared repo:selected branch:cleared': 'showLandingPage',
            'branch:selected': 'showContent'
        },

        template: function() {
            return bamboo.plugins.branchinator.renderContentView();
        },

        onShow: function() {
            this.$el.hide();
            this.landingPage.show(new LandingPageView({
                model: this.model,
                collection: new RecentBranchesCollection()
            }));
            this.builds.show(new BuildsView({ model: this.model }));
            this.showLandingPage();
            this.$el.show();
        },

        showLandingPage: function() {
            this.builds.$el.hide();
            this.landingPage.$el.show();
            this.integrations.reset();
        },

        showContent: function() {
            this.builds.$el.show();
            this.landingPage.$el.hide();
            this.integrations.show(new IntegrationsView({ model: this.model }));
        }
    });
});
