define('branchinator/views/layout-view', [
    'branchinator/regions/header-region',
    'branchinator/utils/radio-utils',
    'branchinator/views/layout/content-view',
    'branchinator/views/layout/header-view',
    'branchinator/views/layout/messages-view',
    'marionette'
], function(
    HeaderRegion,
    radioUtils,
    ContentView,
    HeaderView,
    MessagesView,
    Marionette
) {
    'use strict';

    /**
     * Main layout of the branch status application.
     *
     * Parameters:
     * - model - branch selection model
     * - hasRepositories - whether there are global, branchable repositories defined for this Bamboo
     */
    return Marionette.LayoutView.extend({
        regions: {
            header: {
                selector: '#headerContainer',
                regionClass: HeaderRegion
            },
            messages: '#messagesContainer',
            content: '#contentContainer'
        },

        modelEvents: {
            'repo:cleared repo:selected branch:cleared branch:selected': 'clearErrorMessages'
        },

        initialize: function(options) {
            this.options = options;
        },

        template: function() {
            return bamboo.plugins.branchinator.renderLayoutView();
        },

        onShow: function() {
            var hasRepositories = this.getOption('hasRepositories');

            this.messages.show(new MessagesView({
                hasRepositories: hasRepositories
            }));

            this.header.show(new HeaderView({
                model: this.model,
                hasRepositories: hasRepositories
            }));

            if (hasRepositories) {
                this.content.show(new ContentView({
                    model: this.model
                }));
            }
        },

        clearErrorMessages: function() {
            radioUtils.trigger('message:clear');
        }
    });
});
