define('branchinator/utils/radio-utils', [
    'backbone',
    'underscore'
], function(
    Backbone,
    _
) {
    'use strict';

    var channel = Backbone.Wreqr.radio.channel('branchinator');

    /**
     * Utility methods for interacting with Backbone.Radio. All methods listen to the same channel, which is dedicated
     * to Branchinator application.
     */
    return Object.freeze({

        /**
         * Trigger a global event.
         *
         * @param eventName name of event
         * @param content optional - content of the event to pass to listeners
         */
        trigger: function(eventName, content) {
            channel.vent.trigger(eventName, content);
        },

        /**
         * Listen to a global event.
         *
         * @param eventName name of event
         * @param callback callback function, will be called with parameters from the event as arguments
         */
        listenTo: function(eventName, callback) {
            channel.vent.on(eventName, callback);
        },

        /**
         * Request a global object.
         *
         * @param requestName name of request
         */
        request: function(requestName) {
            return channel.reqres.request(requestName);
        },

        /**
         * Respond to a global request.
         *
         * @param requestName name of request
         * @param response if a function, it will be registered as handler and called on each request; if an object, it
         *     will be returned on each request.
         */
        respondTo: function(requestName, response) {
            var callback = _.isFunction(response) ? response : function() { return response; };
            channel.reqres.setHandler(requestName, callback);
        }
    });
});
