define('branchinator/models/build-model', [
    'backbone',
    'branchinator/utils/branchinator-utils',
    'util/ajax'
], function(
    Backbone,
    bnUtils,
    ajax
) {
    'use strict';

    /**
     * Model representing a single build plan. Contains information about latest build result.
     */
    return Backbone.Model.extend({
        idAttribute: 'planKey',

        isBuildSuccessful: function() {
            return this.get('buildState') === 'Successful';
        },

        isBuildFailed: function() {
            return this.get('buildState') === 'Failed';
        },

        isJustAdded: function() {
            return this.get('justAdded') === true;
        },

        stopBuild: function() {
            return ajax({
                url: bnUtils.getRestUrl('actions/stop?planKey={0}', this.get('planKey')),
                type: 'POST'
            });
        },

        startBuild: function() {
            return ajax({
                url: bnUtils.getRestUrl('actions/start?planKey={0}', this.get('planKey')),
                type: 'POST'
            });
        },

        resumeBuild: function() {
            return ajax({
                url: bnUtils.getRestUrl('actions/resume?planKey={0}', this.get('planKey')),
                type: 'POST'
            });
        },

        deleteBuild: function() {
            return ajax({
                url: bnUtils.getRestUrl('actions/delete?planKey={0}&branchName={1}', this.get('planKey'), encodeURIComponent(this.get('branchName'))),
                type: 'DELETE'
            });
        }
    });
});
