define('branchinator/dialogs/discovery-dialog', [
    'backbone',
    'branchinator/utils/branchinator-utils',
    'jquery',
    'util/ajax'
], function(
    Backbone,
    bnUtils,
    $,
    ajax
) {
    'use strict';

    /**
     * A view used for branch status link discovery dialog.
     */
    return Backbone.View.extend({
        events: {
            'click .close': 'onCloseDialog'
        },

        initialize: function() {
            this.dialog = this.$el.get(0);
            this.dialog.open = true;
        },

        onCloseDialog: function() {
            if (this.$el.is(':visible')) {
                this.$el.hide();
            }
            this.saveDialogDisplayed().done(function() {
                $('#branchStatusLink').addClass('persisted');
            });
        },

        /**
         * Store information that the discovery dialog was displayed. It won't be ever displayed again for current user.
         */
        saveDialogDisplayed: function() {
            var propertyKey = 'plan.page.navigation.discovery.dialog.displayed';
            var data = {
                property: propertyKey,
                value: 'true'
            };

            return ajax({
                url: bnUtils.getRestUrl('config/user/{0}', propertyKey),
                type: 'PUT',
                data: JSON.stringify(data),
                contentType: 'application/json',
                dataType: 'json'
            });
        }
    });
});
