define('branchinator/dialogs/delete-build-confirmation-dialog', [
    'backbone',
    'branchinator/utils/branchinator-utils',
    'branchinator/utils/radio-utils',
    'underscore',
    'widget/dialog'
], function(
    Backbone,
    bnUtils,
    radioUtils,
    _,
    Dialog
) {
    'use strict';

    /**
     * Dialog for confirming deletion of a plan branch.
     *
     * Parameters:
     * - callback - function to be called if user confirms
     */
    return Dialog.extend({
        defaultSettings: {
            width: 600,
            height: 300,
            closeOnOutsideClick: true,
            header: AJS.I18n.getText("branchinator.confirm.disable.branch.title"),
            content: AJS.I18n.getText("branchinator.confirm.disable.branch"),

            buttons: [{
                id: 'delete',
                label: AJS.I18n.getText("branchinator.confirm.disable.branch.button"),
                cssClass: 'aui-button aui-button-primary confirm-delete-plan-branch'
            }, {
                id: 'cancel',
                label: AJS.I18n.getText('global.buttons.cancel'),
                type: 'link',
                cssClass: 'cancel-delete-plan-branch'
            }]
        },

        initialize: function(options) {
            this.callback = options.callback;
            Dialog.prototype.initialize.call(this, this.defaultSettings);
        },

        onButtonClick: function(id) {
            Dialog.prototype.onButtonClick.apply(this, arguments);
            if (id === 'delete') {
                this.callback();
                this.dialog.remove();
            }
        }
    });
});
