define('branchinator/collections/build-commits-collection', [
    'branchinator/utils/branchinator-utils',
    'backbone'
], function(
    bnUtils,
    Backbone
) {
    'use strict';

    /**
     * Collection of most recent commits for the given plan.
     */
    return Backbone.Collection.extend({}, {

        /**
         * Creates new collection for the plan specified by given key.
         *
         * @param planKey key of the plan or plan branch
         */
        forPlanKey: function(planKey) {
            return new this([], {
                url: bnUtils.getRestUrl('commits?planKey={0}', planKey)
            });
        }
    })
});
