define('branchinator/behaviors/fetch-state-aware-behavior', [
    'marionette'
], function(
    Marionette
) {
    'use strict';

    var fetchEvents = {
        'request': 'onFetchStarted',
        'sync error': 'onFetchEnded'
    };

    /**
     * Behavior that stores information about the status of fetching data from server of view's model or collection.
     */
    return Marionette.Behavior.extend({
        collectionEvents: fetchEvents,
        modelEvents: fetchEvents,

        initialize: function() {
            this.resetFetchState();

            this.view.resetFetchState = this.resetFetchState.bind(this);
            this.view.isFetched = this.isFetched.bind(this);
            this.view.isFetching = this.isFetching.bind(this);
        },

        onFetchStarted: function() {
            this.fetchState.fetching = true;
        },

        onFetchEnded: function() {
            this.fetchState.fetching = false;

            if (!this.fetchState.fetched) {
                this.fetchState.fetched = true;
                this.view.triggerMethod('initial:fetch:complete');
            }
        },

        /**
         * Resets the fetch state as if not a single request for the underlying model or collection was sent to server.
         */
        resetFetchState: function() {
            this.fetchState = {
                fetched: false,
                fetching: false
            };
        },

        /**
         * Returns true if at least one fetch operation has completed. Subsequent fetches will not reset the value.
         */
        isFetched: function() {
            return this.fetchState.fetched;
        },

        /**
         * Returns true if the collection or model of this view is currently fetching content from server.
         */
        isFetching: function() {
            return this.fetchState.fetching;
        }
    });
});
