/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.util;

import com.atlassian.bamboo.plugins.branchinator.navigation.KnownNavigationSource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BranchinatorUrlBuilder {
    public static final String BASE_URL = "/branchStatus";
    private long repositoryId;
    private String repositoryName;
    private String branchName;
    private KnownNavigationSource source;

    public BranchinatorUrlBuilder withRepository(long repositoryId, @NotNull String repositoryName) {
        this.repositoryId = repositoryId;
        this.repositoryName = repositoryName;
        return this;
    }

    public BranchinatorUrlBuilder withBranch(@NotNull String branchName) {
        this.branchName = branchName;
        return this;
    }

    public BranchinatorUrlBuilder withSource(@NotNull KnownNavigationSource source) {
        this.source = source;
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder(BASE_URL);
        if (this.repositoryId > 0L && StringUtils.isNotEmpty((CharSequence)this.repositoryName)) {
            sb.append('/').append(this.repositoryId).append('/').append(BranchinatorUrlBuilder.encodePath(this.repositoryName));
            if (StringUtils.isNotEmpty((CharSequence)this.branchName)) {
                sb.append('/').append(BranchinatorUrlBuilder.encodePath(this.branchName));
            }
        }
        if (this.source != null) {
            sb.append("?source=").append(this.source.getAnalyticsName());
        }
        return sb.toString();
    }

    @NotNull
    private static String encodePath(@NotNull String path) {
        try {
            return URLEncoder.encode(path, "UTF-8").replace("+", "%20").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%21", "!").replace("%5C", "%255C").replace("%2F", "%252F");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding UTF-8 not supported", e);
        }
    }
}

