/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class BranchinatorSerializationUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> T parseData(String blob, TypeReference<T> typeReference, T defaultValue) {
        if (StringUtils.isNotEmpty((CharSequence)blob)) {
            try {
                return (T)MAPPER.readValue(blob, typeReference);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String streamData(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

