/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.service;

import com.atlassian.bamboo.plugins.branchinator.service.UserPropertiesService;
import com.atlassian.bamboo.plugins.branchinator.service.UserPropertyKey;
import com.atlassian.bamboo.plugins.branchinator.util.BranchinatorSerializationUtils;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserPropertiesServiceImpl
implements UserPropertiesService {
    private static final String CFG_BRANCHINATOR_USER_PROPERTIES = "branchinator.user.properties";
    private static final TypeReference<Map<String, String>> BRANCHINATOR_USER_PROPERTIES_TYPE = new TypeReference<Map<String, String>>(){};
    private final BambooAuthenticationContext authenticationContext;
    private final BambooUserManager bambooUserManager;

    @Autowired
    public UserPropertiesServiceImpl(@ComponentImport BambooAuthenticationContext authenticationContext, @ComponentImport BambooUserManager bambooUserManager) {
        this.authenticationContext = authenticationContext;
        this.bambooUserManager = bambooUserManager;
    }

    @Override
    @Nullable
    public String getUserProperty(@NotNull UserPropertyKey propertyKey) {
        return this.getUserProperties().getOrDefault(propertyKey.getKey(), null);
    }

    @Override
    public void setUserProperty(@NotNull UserPropertyKey propertyKey, @Nullable String propertyValue) {
        Map<String, String> userProperties = this.getUserProperties();
        if (propertyValue != null) {
            userProperties.put(propertyKey.getKey(), propertyValue);
        } else {
            userProperties.remove(propertyKey.getKey());
        }
        this.setUserProperties(userProperties);
    }

    private User getUser() throws IllegalStateException {
        User user = this.authenticationContext.getUser();
        Preconditions.checkState((user != null ? 1 : 0) != 0, (Object)"No user is currently logged in");
        return user;
    }

    private Map<String, String> getUserProperties() {
        PropertySet propertySet = this.bambooUserManager.getPropertySet(this.getUser());
        return propertySet.exists(CFG_BRANCHINATOR_USER_PROPERTIES) ? (Map)BranchinatorSerializationUtils.parseData(propertySet.getString(CFG_BRANCHINATOR_USER_PROPERTIES), BRANCHINATOR_USER_PROPERTIES_TYPE, new HashMap()) : new HashMap<String, String>();
    }

    private void setUserProperties(Map<String, String> properties) {
        PropertySet propertySet = this.bambooUserManager.getPropertySet(this.getUser());
        propertySet.setString(CFG_BRANCHINATOR_USER_PROPERTIES, BranchinatorSerializationUtils.streamData(properties));
    }
}

