/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.rest;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.branchinator.model.RestErrorCollection;
import com.atlassian.bamboo.plugins.branchinator.rest.RestHelperService;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestHelperServiceImpl
implements RestHelperService {
    private final BambooPermissionManager bambooPermissionManager;
    private final CachedPlanManager cachedPlanManager;
    private final I18nResolver i18nResolver;
    private final PlanManager planManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;

    @Autowired
    public RestHelperServiceImpl(@ComponentImport BambooPermissionManager bambooPermissionManager, @ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport PlanManager planManager, @ComponentImport RepositoryDefinitionManager repositoryDefinitionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
        this.cachedPlanManager = cachedPlanManager;
        this.i18nResolver = i18nResolver;
        this.planManager = planManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    @Override
    public void verifyGlobalPermission(@NotNull BambooPermission permission) throws AccessDeniedException {
        if (!this.bambooPermissionManager.hasGlobalPermission((Permission)permission)) {
            throw new AccessDeniedException(this.i18nResolver.getText("branchinator.rest.error.insufficient.permissions"));
        }
    }

    @Override
    public void verifyPlanPermission(@NotNull ImmutablePlan plan, @NotNull BambooPermission permission) throws AccessDeniedException {
        if (!this.bambooPermissionManager.hasPlanPermission((Permission)permission, plan)) {
            throw new AccessDeniedException(this.i18nResolver.getText("branchinator.rest.error.insufficient.plan.permissions", new Serializable[]{plan.getPlanKey().getKey()}));
        }
    }

    @Override
    public void verifyRepositoryPermission(@NotNull RepositoryDataEntity repository, @NotNull BambooPermission permission) throws AccessDeniedException {
        if (!this.bambooPermissionManager.hasPermission((Permission)permission, (Object)repository, null)) {
            throw new AccessDeniedException(this.i18nResolver.getText("branchinator.rest.error.insufficient.repo.permissions", new Serializable[]{Long.valueOf(repository.getId())}));
        }
    }

    @Override
    public void verifyRepositoryPermission(@NotNull VcsRepositoryData repository, @NotNull BambooPermission permission) throws AccessDeniedException {
        if (!this.bambooPermissionManager.hasPermission((Permission)permission, (Object)repository, null)) {
            throw new AccessDeniedException(this.i18nResolver.getText("branchinator.rest.error.insufficient.repo.permissions", new Serializable[]{Long.valueOf(repository.getId())}));
        }
    }

    @Override
    @NotNull
    public ImmutableChain getImmutableChain(@NotNull PlanKey planKey) throws NotFoundException {
        return (ImmutableChain)Optional.ofNullable(this.cachedPlanManager.getPlanByKeyIfOfType(planKey, ImmutableChain.class)).orElseThrow(() -> new NotFoundException(this.i18nResolver.getText("branchinator.rest.error.plan.not.found", new Serializable[]{planKey})));
    }

    @Override
    @NotNull
    public Chain getMutableChain(@NotNull PlanKey planKey) throws NotFoundException {
        return (Chain)Optional.ofNullable(this.planManager.getPlanByKeyIfOfType(planKey, Chain.class)).orElseThrow(() -> new NotFoundException(this.i18nResolver.getText("branchinator.rest.error.plan.not.found", new Serializable[]{planKey})));
    }

    @Override
    @NotNull
    public RepositoryDataEntity getLinkedRepositoryDataEntity(long repoId) throws NotFoundException {
        return Optional.ofNullable(this.repositoryDefinitionManager.getRepositoryDataEntity(repoId)).filter(RepositoryDataEntity::isGlobal).orElseThrow(() -> new NotFoundException(this.i18nResolver.getText("branchinator.rest.error.repo.not.found", new Serializable[]{String.valueOf(repoId)})));
    }

    @Override
    @NotNull
    public VcsRepositoryData getLinkedRepositoryVcsData(long repoId) throws NotFoundException {
        return Optional.ofNullable(this.repositoryDefinitionManager.getVcsRepositoryData(repoId)).filter(VcsRepositoryData::isLinked).orElseThrow(() -> new NotFoundException(this.i18nResolver.getText("branchinator.rest.error.repo.not.found", new Serializable[]{String.valueOf(repoId)})));
    }

    @Override
    @NotNull
    public Response whileHandlingRestExceptions(@NotNull BambooCallables.Throwing<Response, WebValidationException> code) {
        try {
            return (Response)code.call();
        }
        catch (NotFoundException | UnauthorisedException | AccessDeniedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new RestErrorCollection(e.getMessage())).build();
        }
        catch (WebValidationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RestErrorCollection(e.getErrorCollection())).build();
        }
    }
}

