/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.rest;

import com.atlassian.bamboo.plugins.branchinator.model.RecentBranch;
import com.atlassian.bamboo.plugins.branchinator.service.RecentActivityService;
import com.atlassian.bamboo.plugins.branchinator.service.SelectedBranch;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="recent")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class BranchRecentsResource {
    private final RecentActivityService recentActivityService;
    private final BambooAuthenticationContext authenticationContext;

    @Autowired
    public BranchRecentsResource(RecentActivityService recentActivityService, @ComponentImport BambooAuthenticationContext bambooAuthenticationContext) {
        this.recentActivityService = recentActivityService;
        this.authenticationContext = bambooAuthenticationContext;
    }

    @GET
    @Path(value="branch")
    public Response getRecentBranches() {
        List recentBranches = this.recentActivityService.getRecentlyVisitedBranches(this.authenticationContext.getUser()).stream().map(this::toRecentBranch).collect(Collectors.toList());
        return Response.ok(recentBranches).build();
    }

    private RecentBranch toRecentBranch(SelectedBranch selectedBranch) {
        return new RecentBranch(selectedBranch.getSelectedRepoId(), selectedBranch.getSelectedRepoName(), selectedBranch.getSelectedBranchName());
    }
}

