/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.rest;

import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.ExecutionRequestResult;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.branch.BranchDetectionService;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.PluginKeyProvider;
import com.atlassian.bamboo.plugins.branchinator.model.RestErrorCollection;
import com.atlassian.bamboo.plugins.branchinator.rest.RestHelperService;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="actions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class BranchActionsResource {
    private static final int MAX_BRANCH_NAME_PREFIX_LENGTH = 250;
    private final BambooAuthenticationContext authenticationContext;
    private final BranchDetectionService branchDetectionService;
    private final DeletionService deletionService;
    private final EventPublisher eventPublisher;
    private final I18nResolver i18nResolver;
    private final PlanExecutionManager planExecutionManager;
    private final PlanManager planManager;
    private final RestHelperService restHelperService;
    private final VcsRepositoryManager vcsRepositoryManager;

    @Autowired
    public BranchActionsResource(@ComponentImport BambooAuthenticationContext authenticationContext, @ComponentImport BranchDetectionService branchDetectionService, @ComponentImport DeletionService deletionService, @ComponentImport EventPublisher eventPublisher, @ComponentImport I18nResolver i18nResolver, @ComponentImport PlanExecutionManager planExecutionManager, @ComponentImport PlanManager planManager, RestHelperService restHelperService, @ComponentImport VcsRepositoryManager vcsRepositoryManager) {
        this.authenticationContext = authenticationContext;
        this.branchDetectionService = branchDetectionService;
        this.deletionService = deletionService;
        this.eventPublisher = eventPublisher;
        this.i18nResolver = i18nResolver;
        this.planExecutionManager = planExecutionManager;
        this.planManager = planManager;
        this.restHelperService = restHelperService;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @POST
    @Path(value="start")
    public Response startPlan(@QueryParam(value="planKey") String planKeyString) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            PlanKey planKey = PlanKeys.getPlanKey((String)planKeyString);
            this.restHelperService.verifyGlobalPermission(BambooPermission.READ);
            ImmutableChain chain = this.restHelperService.getImmutableChain(planKey);
            this.restHelperService.verifyPlanPermission((ImmutablePlan)chain, BambooPermission.BUILD);
            Map<String, String> executionParams = Collections.singletonMap("dependenciesDisabled", "false");
            Map customVariables = Collections.emptyMap();
            ExecutionRequestResult result = this.planExecutionManager.startManualExecution(chain, this.authenticationContext.getUser(), executionParams, customVariables);
            PlanResultKey planResultKey = result.getPlanResultKey();
            return planResultKey != null ? Response.ok().build() : Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RestErrorCollection((String)result.getErrors().getErrorMessages().iterator().next())).build();
        }));
    }

    @POST
    @Path(value="stop")
    public Response stopPlan(@QueryParam(value="planKey") String planKeyString) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            PlanKey planKey = PlanKeys.getPlanKey((String)planKeyString);
            this.restHelperService.verifyGlobalPermission(BambooPermission.READ);
            ImmutableChain chain = this.restHelperService.getImmutableChain(planKey);
            this.restHelperService.verifyPlanPermission((ImmutablePlan)chain, BambooPermission.BUILD);
            if (this.planExecutionManager.isBusy(planKey)) {
                this.planExecutionManager.stopRequest(planKey);
            } else {
                try {
                    this.planExecutionManager.stopPlan(planKey, false, this.authenticationContext.getUser().getFullName());
                }
                catch (InterruptedException e) {
                    throw new WebValidationException(this.i18nResolver.getText("branchinator.rest.error.stopping.plan.failed", new Serializable[]{planKey}));
                }
            }
            return Response.ok().build();
        }));
    }

    @POST
    @Path(value="resume")
    public Response resumeBuild(@QueryParam(value="planKey") String planKeyString) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            PlanKey planKey = PlanKeys.getPlanKey((String)planKeyString);
            this.restHelperService.verifyGlobalPermission(BambooPermission.READ);
            ImmutableChain chain = this.restHelperService.getImmutableChain(planKey);
            this.restHelperService.verifyPlanPermission((ImmutablePlan)chain, BambooPermission.BUILD);
            this.planManager.setPlanSuspendedState(chain.getPlanKey(), false);
            this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, chain.getPlanKey()));
            return Response.ok().build();
        }));
    }

    @POST
    @Path(value="create")
    public Response createPlan(@QueryParam(value="planKey") String planKeyString, @QueryParam(value="branchName") String branchName) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            PlanKey createdPlanKey;
            BambooValidationUtils.validateField((String)"planKey", (boolean)StringUtils.isNotEmpty((String)planKeyString), () -> this.i18nResolver.getText("branchinator.rest.error.plan.key.empty"));
            BambooValidationUtils.validateField((String)"branchName", (boolean)StringUtils.isNotEmpty((String)branchName), () -> this.i18nResolver.getText("branchinator.rest.error.branch.name.empty"));
            PlanKey planKey = PlanKeys.getPlanKey((String)planKeyString);
            this.restHelperService.verifyGlobalPermission(BambooPermission.READ);
            ImmutableChain chain = this.restHelperService.getImmutableChain(planKey);
            this.restHelperService.verifyPlanPermission((ImmutablePlan)chain, BambooPermission.ADMINISTRATION);
            VcsBranch vcsBranch = this.getVcsBranchForName(chain, branchName);
            String chainBranchName = this.getValidChainBranchName(vcsBranch);
            try {
                createdPlanKey = this.branchDetectionService.createChainBranch(chain, chainBranchName, vcsBranch, null, PlanCreationService.EnablePlan.ENABLED, true);
            }
            catch (PlanCreationDeniedException e) {
                throw new WebValidationException(this.i18nResolver.getText("branchinator.rest.error.creating.plan.failed", new Serializable[]{planKeyString, branchName}));
            }
            return Response.ok(Collections.singletonMap("branchKey", createdPlanKey.getKey())).build();
        }));
    }

    @DELETE
    @Path(value="delete")
    public Response deletePlan(@QueryParam(value="planKey") String planKeyString) {
        return this.restHelperService.whileHandlingRestExceptions((BambooCallables.Throwing<Response, WebValidationException>)((BambooCallables.Throwing)() -> {
            PlanKey planKey = PlanKeys.getPlanKey((String)planKeyString);
            Chain chain = this.restHelperService.getMutableChain(planKey);
            this.restHelperService.verifyPlanPermission((ImmutablePlan)chain, BambooPermission.ADMINISTRATION);
            this.deletionService.deletePlan((Plan)chain);
            return Response.ok().build();
        }));
    }

    private String getValidChainBranchName(VcsBranch newBranch) {
        String branchNameWithValidChars = StringUtils.replaceChars((String)newBranch.getDisplayName().trim(), (String)"[]{}<>:@/&%\\!|#$*;~", (String)StringUtils.repeat((String)"-", (int)"[]{}<>:@/&%\\!|#$*;~".length()));
        return StringUtils.substring((String)branchNameWithValidChars, (int)0, (int)250).trim();
    }

    private VcsBranch getVcsBranchForName(ImmutableChain chain, String branchName) {
        return Optional.ofNullable(PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain)).map(PluginKeyProvider::getPluginKey).map(arg_0 -> ((VcsRepositoryManager)this.vcsRepositoryManager).getVcsRepositoryModuleDescriptor(arg_0)).map(VcsRepositoryModuleDescriptor::getVcsBranchConfigurator).map(branchConfigurator -> branchConfigurator.createVcsBranchFromName(branchName)).orElse((VcsBranch)new VcsBranchImpl(branchName));
    }
}

