/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.navigation;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BranchinatorNavigationHelper {
    private final CachedPlanManager cachedPlanManager;

    @Autowired
    public BranchinatorNavigationHelper(@ComponentImport CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    @Nullable
    public <T extends ImmutablePlan> T getPlanFromPageContext(@NotNull Map<String, Object> context, @NotNull Class<T> planClass) {
        Object planObject;
        if (context.containsKey("plan") && planClass.isInstance(planObject = context.get("plan"))) {
            return (T)((ImmutablePlan)planClass.cast(planObject));
        }
        String planKeyString = StringUtils.defaultString((String)((String)context.get("planKey")), (String)((String)context.get("buildKey")));
        if (StringUtils.isNotBlank((CharSequence)planKeyString)) {
            try {
                PlanKey planKey = PlanKeys.getPlanKey((String)planKeyString);
                return (T)this.cachedPlanManager.getPlanByKey(planKey, planClass);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

