/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.model;

import com.atlassian.bamboo.plugins.branchinator.model.StatusIcon;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RestBranchBuild {
    @XmlElement
    private String projectName;
    @XmlElement
    private String planName;
    @XmlElement
    private String branchName;
    @XmlElement
    private boolean hasBuildPermission;
    @XmlElement
    private boolean hasEditPermission;
    @XmlElement
    private boolean hasPlanAdminPermission;
    @XmlElement
    private String testResultsSummary;
    @XmlElement
    private StatusIcon statusIcon;
    @XmlElement
    private Integer buildNumber;
    @XmlElement
    private Integer latestActiveBuildNumber;
    @XmlElement
    private String planKey;
    @XmlElement
    private String lastBuildTime;
    @XmlElement
    private long lastBuildEpoch;
    @XmlElement
    private String buildState;
    @XmlElement
    private String reason;
    @XmlElement
    private int numberOfCurrentlyBuildingPlans;
    @XmlElement
    private int nrCommits;
    @XmlElement
    private boolean committerIsCurrentUser;

    public RestBranchBuild(String projectName, String planName, String branchName, StatusIcon statusIcon, Integer buildNumber, Integer latestActiveBuildNumber, String planKey, String lastBuildTime, long lastBuildEpoch, String buildState, String reason, String testResultsSummary, boolean hasBuildPermission, boolean hasEditPermission, boolean hasPlanAdminPermission, int numberOfCurrentlyBuildingPlans, int nrCommits, boolean committerIsCurrentUser) {
        this.projectName = projectName;
        this.planName = planName;
        this.branchName = branchName;
        this.statusIcon = statusIcon;
        this.buildNumber = buildNumber;
        this.latestActiveBuildNumber = latestActiveBuildNumber;
        this.planKey = planKey;
        this.lastBuildTime = lastBuildTime;
        this.lastBuildEpoch = lastBuildEpoch;
        this.buildState = buildState;
        this.reason = reason;
        this.testResultsSummary = testResultsSummary;
        this.hasBuildPermission = hasBuildPermission;
        this.hasEditPermission = hasEditPermission;
        this.hasPlanAdminPermission = hasPlanAdminPermission;
        this.numberOfCurrentlyBuildingPlans = numberOfCurrentlyBuildingPlans;
        this.nrCommits = nrCommits;
        this.committerIsCurrentUser = committerIsCurrentUser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getLastBuildEpoch() {
        return this.lastBuildEpoch;
    }

    public StatusIcon getStatusIcon() {
        return this.statusIcon;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getPlanName() {
        return this.planName;
    }

    public static class Builder {
        private String projectName;
        private String planName;
        private String branchName;
        private String testResultsSummary;
        private StatusIcon statusIcon;
        private Integer buildNumber;
        private Integer latestActiveBuildNumber;
        private String planKey;
        private String lastBuildTime;
        private long lastBuildEpoch;
        private String buildState;
        private String reason;
        private boolean hasBuildPermission;
        private boolean hasEditPermission;
        private boolean hasPlanAdminPermission;
        private int nrCommits;
        private boolean committerIsCurrentUser;
        private int numberOfCurrentlyBuildingPlans;

        Builder() {
        }

        public RestBranchBuild build() {
            return new RestBranchBuild(this.projectName, this.planName, this.branchName, this.statusIcon, this.buildNumber, this.latestActiveBuildNumber, this.planKey, this.lastBuildTime, this.lastBuildEpoch, this.buildState, this.reason, this.testResultsSummary, this.hasBuildPermission, this.hasEditPermission, this.hasPlanAdminPermission, this.numberOfCurrentlyBuildingPlans, this.nrCommits, this.committerIsCurrentUser);
        }

        public Builder testResultsSummary(String testResultsSummary) {
            this.testResultsSummary = testResultsSummary;
            return this;
        }

        public Builder projectName(String name) {
            this.projectName = name;
            return this;
        }

        public Builder planName(String name) {
            this.planName = name;
            return this;
        }

        public Builder branchName(String name) {
            this.branchName = name;
            return this;
        }

        public Builder statusIcon(StatusIcon statusIcon) {
            this.statusIcon = statusIcon;
            return this;
        }

        public Builder buildNumber(int buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        public Builder latestActiveBuildNumber(int latestActiveBuildNumber) {
            this.latestActiveBuildNumber = latestActiveBuildNumber;
            return this;
        }

        public Builder planKey(String planKey) {
            this.planKey = planKey;
            return this;
        }

        public Builder lastBuildTime(String lastBuildTime) {
            this.lastBuildTime = lastBuildTime;
            return this;
        }

        public Builder lastBuildEpoch(long lastBuildEpoch) {
            this.lastBuildEpoch = lastBuildEpoch;
            return this;
        }

        public Builder buildState(String buildState) {
            this.buildState = buildState;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder hasBuildPermission(boolean hasBuildPermission) {
            this.hasBuildPermission = hasBuildPermission;
            return this;
        }

        public Builder hasEditPermission(boolean hasEditPermission) {
            this.hasEditPermission = hasEditPermission;
            return this;
        }

        public Builder hasPlanAdminPermission(boolean hasPlanAdminPermission) {
            this.hasPlanAdminPermission = hasPlanAdminPermission;
            return this;
        }

        public Builder numberOfCurrentlyBuildingPlans(int numberOfCurrentlyBuildingPlans) {
            this.numberOfCurrentlyBuildingPlans = numberOfCurrentlyBuildingPlans;
            return this;
        }

        public Builder nrCommits(int nrCommits) {
            this.nrCommits = nrCommits;
            return this;
        }

        public Builder committerIsCurrentUser(boolean committerIsCurrentUser) {
            this.committerIsCurrentUser = committerIsCurrentUser;
            return this;
        }
    }
}

