/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.model;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public enum BuildsSortOrder {
    BY_BUILD_STATUS("buildStatus", "branchinator.available.builds.orderBy.buildStatus"),
    BY_PLAN_NAME("planName", "branchinator.available.builds.orderBy.planName"),
    BY_COMPLETION_DATE("completionDate", "branchinator.available.builds.orderBy.completionDate");

    public static final BuildsSortOrder DEFAULT;
    private final String column;
    private final String labelKey;

    private BuildsSortOrder(String columnName, String labelKey) {
        this.column = columnName;
        this.labelKey = labelKey;
    }

    @NotNull
    public String getColumn() {
        return this.column;
    }

    @NotNull
    public String getLabelKey() {
        return this.labelKey;
    }

    @NotNull
    public static BuildsSortOrder forColumn(@NotNull String columnName) {
        return Arrays.stream(BuildsSortOrder.values()).filter(sortOrder -> sortOrder.getColumn().equals(columnName)).findAny().orElse(DEFAULT);
    }

    static {
        DEFAULT = BY_BUILD_STATUS;
    }
}

