/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.data;

import com.atlassian.bamboo.plugins.branchinator.model.BuildsSortOrder;
import com.atlassian.bamboo.plugins.branchinator.model.RestBuildsSortOrder;
import com.atlassian.bamboo.plugins.branchinator.service.UserPropertiesService;
import com.atlassian.bamboo.plugins.branchinator.service.UserPropertyKey;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BuildsSortOrderingsDataProvider
implements WebResourceDataProvider {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final BambooAuthenticationContext authenticationContext;
    private final I18nResolver i18nResolver;
    private final UserPropertiesService userPropertiesService;

    @Autowired
    public BuildsSortOrderingsDataProvider(@ComponentImport BambooAuthenticationContext authenticationContext, @ComponentImport I18nResolver i18nResolver, UserPropertiesService userPropertiesService) {
        this.authenticationContext = authenticationContext;
        this.i18nResolver = i18nResolver;
        this.userPropertiesService = userPropertiesService;
    }

    public Jsonable get() {
        String sortOrderForUser = Optional.ofNullable(this.authenticationContext.getUser()).map(user -> this.userPropertiesService.getUserProperty(UserPropertyKey.BUILDS_SORT_ORDER)).orElse(null);
        List sources = Arrays.stream(BuildsSortOrder.values()).map(order -> this.toRestSortOrder((BuildsSortOrder)((Object)order), sortOrderForUser)).collect(Collectors.toList());
        return writer -> this.objectMapper.writeValue(writer, (Object)sources);
    }

    private RestBuildsSortOrder toRestSortOrder(BuildsSortOrder order, String sortOrderForUser) {
        return new RestBuildsSortOrder(order.getColumn(), this.i18nResolver.getText(order.getLabelKey()), order.getColumn().equals(sortOrderForUser));
    }
}

