/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bamboo.plugins.branchinator.ao.BranchSelection;
import com.atlassian.bamboo.plugins.branchinator.ao.BranchSelectionStore;
import com.atlassian.bamboo.plugins.branchinator.service.SelectedBranch;
import com.atlassian.bamboo.plugins.branchinator.util.BranchinatorSerializationUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BranchSelectionStoreImpl
implements BranchSelectionStore {
    public static final int NUMBER_OF_PERSISTED_BRANCHES = 5;
    private static final TypeReference<List<SelectedBranch>> SELECTED_BRANCHES_TYPE = new TypeReference<List<SelectedBranch>>(){};
    private final ActiveObjects ao;

    @Autowired
    public BranchSelectionStoreImpl(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void saveBranchSelection(@NotNull User user, long repoId, @NotNull String branchName) {
        if (StringUtils.isBlank((CharSequence)branchName)) {
            return;
        }
        BranchSelection branchSelection = this.getOrCreateBranchSelection(user);
        branchSelection.setSelectedRepoId(repoId);
        branchSelection.setSelectedBranchName(branchName);
        List branches = BranchinatorSerializationUtils.parseData(branchSelection.getLastSelectedBranches(), SELECTED_BRANCHES_TYPE, new ArrayList());
        SelectedBranch branchSelectionImpl = new SelectedBranch(repoId, branchName);
        if (branches.contains(branchSelectionImpl)) {
            branches.remove(branchSelectionImpl);
        }
        branches.add(0, branchSelectionImpl);
        branchSelection.setLastSelectedBranches(BranchinatorSerializationUtils.streamData(branches.subList(0, Math.min(5, branches.size()))));
        branchSelection.save();
    }

    @Override
    @NotNull
    public List<SelectedBranch> getRecentBranches(@NotNull User user) {
        BranchSelection selection = this.getBranchSelection(user);
        if (selection != null) {
            if (StringUtils.isNotEmpty((CharSequence)selection.getLastSelectedBranches())) {
                return BranchinatorSerializationUtils.parseData(selection.getLastSelectedBranches(), SELECTED_BRANCHES_TYPE, new ArrayList());
            }
            SelectedBranch recentBranch = new SelectedBranch(selection.getSelectedRepoId(), "", selection.getSelectedBranchName());
            return Lists.newArrayList((Object[])new SelectedBranch[]{recentBranch});
        }
        return Lists.newArrayList();
    }

    private BranchSelection getBranchSelection(User user) {
        if (user == null) {
            return null;
        }
        Query clause = Query.select().where("USER = ?", new Object[]{user.getName()});
        BranchSelection[] branchSelections = (BranchSelection[])this.ao.find(BranchSelection.class, clause);
        if (branchSelections.length < 1) {
            return null;
        }
        return branchSelections[0];
    }

    private BranchSelection getOrCreateBranchSelection(User user) {
        BranchSelection branchSelection = this.getBranchSelection(user);
        if (branchSelection == null) {
            branchSelection = (BranchSelection)this.ao.create(BranchSelection.class, new DBParam[0]);
            branchSelection.setUser(user.getName());
        }
        return branchSelection;
    }
}

