/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.branchinator.actions;

import com.atlassian.bamboo.plugins.branchinator.util.BranchinatorUrlBuilder;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.AuthenticatedUserSecurityAware;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.util.concurrent.Lazy;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ViewBranchBuilds
extends BambooActionSupport
implements AuthenticatedUserSecurityAware {
    private static final String REDIRECT = "redirect";
    @ComponentImport
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @ComponentImport
    private VcsRepositoryManager vcsRepositoryManager;
    private long repoId;
    private String repoName = "";
    private String branchName;
    private String prettyUrl;
    private final Supplier<List<VcsRepositoryData>> globalRepositoryDefinitions = Lazy.supplier(() -> this.repositoryDefinitionManager.getLinkedRepositories());

    public String execute() throws Exception {
        String currentUrl = this.getCurrentUrl();
        if (StringUtils.startsWith((CharSequence)currentUrl, (CharSequence)"/branch/") && ServletActionContext.getRequest().getAttribute("pretty.urls.fromURI") == null) {
            return this.prettyRedirect();
        }
        return "success";
    }

    private String prettyRedirect() throws URISyntaxException, UnsupportedEncodingException {
        this.prettyUrl = this.generatePrettyUrl();
        return REDIRECT;
    }

    public String generatePrettyUrl() throws UnsupportedEncodingException {
        BranchinatorUrlBuilder urlBuilder = new BranchinatorUrlBuilder();
        if (this.isRepositorySelected()) {
            urlBuilder.withRepository(this.repoId, this.repoName);
            if (this.isBranchSelected()) {
                urlBuilder.withBranch(this.branchName);
            }
        }
        return urlBuilder.build();
    }

    public String getPrettyUrl() {
        return this.prettyUrl;
    }

    public void setRepoId(long repoId) {
        RepositoryDataEntity repositoryDataEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(repoId);
        if (repositoryDataEntity != null) {
            this.repoName = repositoryDataEntity.getName();
            this.repoId = repoId;
        }
    }

    public Long getRepoId() {
        return this.repoId;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getBranchName() {
        return StringUtils.defaultString((String)this.branchName);
    }

    private boolean isRepositorySelected() {
        return this.repoId > 0L && StringUtils.isNotEmpty((CharSequence)this.repoName);
    }

    private boolean isBranchSelected() {
        return StringUtils.isNotEmpty((CharSequence)this.branchName);
    }

    public boolean hasGlobalRepositories() {
        return !this.globalRepositoryDefinitions.get().isEmpty();
    }

    public boolean hasBranchAwareRepositories() {
        return this.globalRepositoryDefinitions.get().stream().map(r -> this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(r.getPluginKey())).filter(Objects::nonNull).anyMatch(VcsRepositoryModuleDescriptor::supportsBranchDetection);
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }
}

