/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.inject;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.variable.inject.VariableScope;
import com.atlassian.bamboo.specs.model.task.InjectVariablesTaskProperties;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.VariableContext;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class InjectVariablesTask
implements CommonTaskType {
    private static final Logger log = Logger.getLogger(InjectVariablesTask.class);

    public TaskResult execute(@NotNull CommonTaskContext taskContext) {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        TaskResultBuilder builder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        String filePath = (String)taskContext.getConfigurationMap().get((Object)"filePath");
        File file = new File(taskContext.getWorkingDirectory(), filePath);
        if (!file.isFile()) {
            buildLogger.addErrorLogEntry("Could not read variable file at '" + file.getAbsolutePath() + "' as it does not exist.");
            return builder.failedWithError().build();
        }
        VariableScope scope = VariableScope.valueOf((String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)taskContext.getConfigurationMap().get((Object)"scope")), (CharSequence)VariableScope.LOCAL.name()));
        Properties properties = this.loadProperties(buildLogger, file);
        String namespace = (String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)taskContext.getConfigurationMap().get((Object)"namespace")), (CharSequence)InjectVariablesTaskProperties.DEFAULT_NAMESPACE);
        this.injectVariables(properties, taskContext, namespace, scope);
        return builder.success().build();
    }

    private void injectVariables(Properties properties, CommonTaskContext taskContext, String namespace, VariableScope scope) {
        VariableContext variableContext = taskContext.getCommonContext().getVariableContext();
        for (Map.Entry<Object, Object> variable : properties.entrySet()) {
            String key = namespace + "." + variable.getKey();
            String value = variable.getValue().toString();
            if (VariableScope.RESULT == scope) {
                variableContext.addResultVariable(key, value);
            } else {
                variableContext.addLocalVariable(key, value);
            }
            if (PasswordMaskingUtils.shouldBeMasked((String)key)) {
                value = "******";
            }
            taskContext.getBuildLogger().addBuildLogEntry("Injected variable bamboo." + key + "=" + value + " in " + (Object)((Object)scope) + " scope");
        }
    }

    @VisibleForTesting
    Properties loadProperties(BuildLogger buildLogger, File file) {
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));){
            properties.load(reader);
        }
        catch (IOException e) {
            String message = "Could not read variable file at '" + file.getAbsolutePath() + "'";
            buildLogger.addErrorLogEntry(message, (Throwable)e);
        }
        return properties;
    }
}

