/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.npm;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.nodejs.tasks.node.NodeCapabilityDefaultsHelper;
import com.atlassian.bamboo.plugins.nodejs.tasks.npm.NpmIsolatedCacheHelper;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public class NpmTaskType
implements CommonTaskType {
    private static final String NPM_ISOLATED_CACHE_DIRECTORY = "npm.isolated.cache.directory";
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private final I18nResolver i18nResolver;
    private final AgentContext agentContext;

    public NpmTaskType(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, I18nResolver i18nResolver, AgentContext agentContext) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        this.i18nResolver = i18nResolver;
        this.agentContext = agentContext;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        try {
            BuildLogger buildLogger = taskContext.getBuildLogger();
            ConfigurationMap configurationMap = taskContext.getConfigurationMap();
            String nodeRuntime = (String)configurationMap.get((Object)"runtime");
            String nodePath = this.capabilityContext.getCapabilityValue("system.builder.node." + nodeRuntime);
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)nodePath), (Object)this.i18nResolver.getText("node.runtime.error.undefinedPath"));
            String npmPath = NpmTaskType.convertNodePathToNpmPath(nodePath);
            String command = (String)configurationMap.get((Object)"command");
            Map extraEnvironmentVariables = this.environmentVariableAccessor.splitEnvironmentAssignments((String)configurationMap.get((Object)"environmentVariables"), false);
            List arguments = CommandlineStringUtils.tokeniseCommandline((String)command);
            ImmutableList.Builder commandListBuilder = ImmutableList.builder();
            if (!SystemUtils.IS_OS_WINDOWS) {
                commandListBuilder.add((Object)nodePath);
            }
            commandListBuilder.add((Object)npmPath).addAll((Iterable)arguments);
            boolean useIsolatedCache = configurationMap.getAsBoolean("isolatedCache");
            if (useIsolatedCache) {
                String cacheDirectory = NpmTaskType.getTemporaryCacheDirectory(taskContext, this.agentContext);
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("npm.isolatedCache.usage", new Serializable[]{cacheDirectory}));
                commandListBuilder.add((Object[])new String[]{"--cache", cacheDirectory});
            }
            TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
            taskResultBuilder.checkReturnCode(this.processService.executeExternalProcess(taskContext, new ExternalProcessBuilder().command((List)commandListBuilder.build()).env(extraEnvironmentVariables).path(FilenameUtils.getFullPath((String)nodePath)).workingDirectory(taskContext.getWorkingDirectory())));
            return taskResultBuilder.build();
        }
        catch (Exception e) {
            throw new TaskException("Failed to execute task", (Throwable)e);
        }
    }

    @NotNull
    protected static String convertNodePathToNpmPath(@NotNull String nodePath) {
        return FilenameUtils.getFullPath((String)nodePath) + NodeCapabilityDefaultsHelper.NPM_EXECUTABLE_NAME;
    }

    @NotNull
    protected static String getTemporaryCacheDirectory(@NotNull CommonTaskContext taskContext, @NotNull AgentContext agentContext) throws IOException {
        Map customBuildData = taskContext.getCommonContext().getCurrentResult().getCustomBuildData();
        if (!customBuildData.containsKey(NPM_ISOLATED_CACHE_DIRECTORY)) {
            ExecutableBuildAgent buildAgent = agentContext.getBuildAgent();
            Preconditions.checkState((buildAgent != null ? 1 : 0) != 0, (Object)"No build agent detected that is currently executing the task");
            File tempCacheDirectory = NpmIsolatedCacheHelper.initializeTemporaryCacheDirectory(buildAgent.getId());
            customBuildData.put(NPM_ISOLATED_CACHE_DIRECTORY, tempCacheDirectory.getAbsolutePath());
        }
        return (String)customBuildData.get(NPM_ISOLATED_CACHE_DIRECTORY);
    }
}

