/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser;

import com.atlassian.bamboo.plugins.testresultparser.task.exporter.TestParserTaskExporter;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.MochaParserTask;
import com.atlassian.bamboo.specs.model.task.MochaParserTaskProperties;
import com.atlassian.bamboo.specs.model.task.TestParserTaskProperties;
import com.atlassian.bamboo.task.ImmutableTaskDefinition;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MochaParserTaskExporter
extends TestParserTaskExporter {
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        if (taskProperties instanceof MochaParserTaskProperties) {
            MochaParserTaskProperties typedTaskProperties = (MochaParserTaskProperties)taskProperties;
            return ImmutableMap.builder().put((Object)"testPattern", (Object)typedTaskProperties.getTestFilePattern()).put((Object)"workingSubDirectory", (Object)StringUtils.defaultString((String)typedTaskProperties.getWorkingSubdirectory())).put((Object)"pickupOutdatedFiles", (Object)Boolean.toString(typedTaskProperties.isPickUpTestResultsCreatedOutsideOfThisBuild())).build();
        }
        return MochaParserTaskExporter.transformKey(super.toTaskConfiguration(taskContainer, taskProperties), "testResultsDirectory", "testPattern");
    }

    @NotNull
    protected TestParserTaskProperties.TestType getTestType() {
        return TestParserTaskProperties.TestType.MOCHA;
    }

    @NotNull
    public Task toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map taskConfiguration = taskDefinition.getConfiguration();
        String workingSubDirectory = taskConfiguration.getOrDefault("workingSubDirectory", null);
        if (StringUtils.isNotBlank((String)workingSubDirectory)) {
            MochaParserTask mochaParserTask = new MochaParserTask().testFilePattern((String)taskConfiguration.get("testPattern")).workingSubdirectory(workingSubDirectory);
            if (taskConfiguration.containsKey("pickupOutdatedFiles")) {
                mochaParserTask.pickUpTestResultsCreatedOutsideOfThisBuild(Boolean.parseBoolean((String)taskConfiguration.get("pickupOutdatedFiles")));
            }
            return mochaParserTask;
        }
        return super.toSpecsEntity((TaskDefinition)new MochaTaskDefinition(taskDefinition));
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        if (taskProperties instanceof MochaParserTaskProperties) {
            ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
            MochaParserTaskProperties typedTaskProperties = (MochaParserTaskProperties)taskProperties;
            if (StringUtils.isBlank((String)typedTaskProperties.getTestFilePattern())) {
                validationProblems.add(new ValidationProblem(MochaParserTaskProperties.VALIDATION_CONTEXT, "Test file pattern is not defined"));
            }
            return validationProblems;
        }
        return super.validate(taskValidationContext, taskProperties);
    }

    @NotNull
    private static Map<String, String> transformKey(@NotNull Map<String, String> config, @NotNull String currentKey, @NotNull String newKey) {
        HashMap<String, String> translatedConfig = new HashMap<String, String>(config);
        if (config.containsKey(currentKey)) {
            translatedConfig.put(newKey, config.get(currentKey));
            translatedConfig.remove(currentKey);
        }
        return Collections.unmodifiableMap(translatedConfig);
    }

    private static class MochaTaskDefinition
    extends ImmutableTaskDefinition {
        MochaTaskDefinition(@NotNull TaskDefinition taskDefinition) {
            super(taskDefinition);
        }

        @NotNull
        public Map<String, String> getConfiguration() {
            return MochaParserTaskExporter.transformKey(super.getConfiguration(), "testPattern", "testResultsDirectory");
        }
    }
}

