/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.bower;

import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskExporter;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.BowerTask;
import com.atlassian.bamboo.specs.model.task.BowerTaskProperties;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class BowerTaskExporter
extends AbstractNodeRequiringTaskExporter<BowerTaskProperties, BowerTask> {
    @Autowired
    public BowerTaskExporter(UIConfigSupport uiConfigSupport) {
        super(BowerTaskProperties.class, uiConfigSupport);
    }

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return BowerTaskProperties.VALIDATION_CONTEXT;
    }

    @Override
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull BowerTaskProperties taskProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bowerRuntime", taskProperties.getBowerExecutable());
        config.put("command", taskProperties.getCommand());
        return config;
    }

    @Override
    @NotNull
    protected BowerTask toSpecsEntity(@NotNull Map<String, String> taskConfiguration) {
        return new BowerTask().bowerExecutable(taskConfiguration.get("bowerRuntime")).command(taskConfiguration.get("command"));
    }

    @Override
    @NotNull
    public List<ValidationProblem> validate(@NotNull BowerTaskProperties taskProperties) {
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        if (StringUtils.isBlank((String)taskProperties.getBowerExecutable())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Bower executable is not defined"));
        }
        if (StringUtils.isBlank((String)taskProperties.getCommand())) {
            validationProblems.add(new ValidationProblem(this.getValidationContext(), "Command is not defined"));
        }
        return validationProblems;
    }
}

