/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNodeRequiringTaskConfigurator
extends AbstractNodeTaskConfigurator {
    public static final String NODE_RUNTIME = "runtime";
    protected static final Set<String> FIELDS_TO_COPY = ImmutableSet.builder().addAll(AbstractNodeTaskConfigurator.FIELDS_TO_COPY).add((Object)"environmentVariables").add((Object)"runtime").build();
    protected static final Map<String, Object> DEFAULT_FIELD_VALUES = ImmutableMap.builder().putAll(AbstractNodeTaskConfigurator.DEFAULT_FIELD_VALUES).build();

    @Override
    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition) {
        String nodeRuntime = (String)taskDefinition.getConfiguration().get(NODE_RUNTIME);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)nodeRuntime), (Object)this.i18nResolver.getText("node.runtime.error.empty"));
        return Collections.singleton(new RequirementImpl("system.builder.node." + nodeRuntime, true, ".*"));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isEmpty((CharSequence)params.getString(NODE_RUNTIME))) {
            errorCollection.addError(NODE_RUNTIME, this.i18nResolver.getText("node.runtime.error.empty"));
        }
    }

    @Override
    @NotNull
    public Set<String> getFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    @NotNull
    public Map<String, Object> getDefaultFieldValues() {
        return DEFAULT_FIELD_VALUES;
    }
}

