/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.npm;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class NpmIsolatedCacheHelper {
    private static final Logger log = Logger.getLogger(NpmIsolatedCacheHelper.class);
    private static final String CACHE_DIR_PATH = Joiner.on((String)File.separator).join((Object)"bamboo-nodejs-plugin", (Object)"npm-cache-%d", new Object[0]);

    private NpmIsolatedCacheHelper() {
    }

    @NotNull
    static File initializeTemporaryCacheDirectory(long agentId) throws IOException {
        File cacheDirectory = NpmIsolatedCacheHelper.getCacheDirectory(agentId);
        if (cacheDirectory.exists() && !cacheDirectory.isDirectory()) {
            log.info((Object)String.format("Removing a file that has the the same name as cache folder but isn't a directory (agent id %d): %s", agentId, cacheDirectory.getAbsolutePath()));
            FileUtils.forceDelete((File)cacheDirectory);
        }
        if (!cacheDirectory.exists()) {
            log.debug((Object)String.format("Creating new cache directory (agent id %d): %s", agentId, cacheDirectory.getAbsolutePath()));
            FileUtils.forceMkdir((File)cacheDirectory);
        } else {
            log.debug((Object)String.format("Cleaning content of cache directory (agent id %d): %s", agentId, cacheDirectory.getAbsolutePath()));
            FileUtils.cleanDirectory((File)cacheDirectory);
        }
        return cacheDirectory;
    }

    static void deleteTemporaryCacheDirectory(long agentId) throws IOException {
        File cacheDirectory = NpmIsolatedCacheHelper.getCacheDirectory(agentId);
        if (cacheDirectory.exists()) {
            log.debug((Object)String.format("Deleting cache directory (agent id %d): %s", agentId, cacheDirectory.getAbsolutePath()));
            FileUtils.deleteDirectory((File)cacheDirectory);
        } else {
            log.debug((Object)String.format("Called to delete npm cache directory but it didn't exist (agent id %d): %s", agentId, cacheDirectory.getAbsolutePath()));
        }
    }

    @NotNull
    private static File getCacheDirectory(long agentId) {
        return new File(FileUtils.getTempDirectory(), String.format(CACHE_DIR_PATH, agentId));
    }
}

