/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser.MochaSuite;
import com.atlassian.bamboo.plugins.nodejs.tasks.mocha.parser.MochaSuiteTest;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MochaReportCollector
implements TestReportCollector {
    private static final Logger log = Logger.getLogger(MochaReportCollector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TestCollectionResult collect(@NotNull File file) throws Exception {
        MochaSuite results;
        ArrayList pass = Lists.newArrayList();
        ArrayList fail = Lists.newArrayList();
        ArrayList skip = Lists.newArrayList();
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").create();
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        try {
            results = (MochaSuite)gson.fromJson((Reader)fileReader, MochaSuite.class);
        }
        finally {
            IOUtils.closeQuietly((Reader)fileReader);
        }
        for (MochaSuiteTest test : results.getPasses()) {
            pass.add(MochaReportCollector.toTestResult(test, TestState.SUCCESS));
        }
        for (MochaSuiteTest test : results.getFailures()) {
            fail.add(MochaReportCollector.toTestResult(test, TestState.FAILED));
        }
        for (MochaSuiteTest test : results.getSkipped()) {
            skip.add(MochaReportCollector.toTestResult(test, TestState.SKIPPED));
        }
        TestCollectionResultBuilder builder = new TestCollectionResultBuilder();
        log.info((Object)results.toString());
        builder.addSuccessfulTestResults((Collection)pass);
        builder.addFailedTestResults((Collection)fail);
        builder.addSkippedTestResults((Collection)skip);
        return builder.build();
    }

    @NotNull
    public Set<String> getSupportedFileExtensions() {
        return Sets.newHashSet((Object[])new String[]{"json"});
    }

    private static TestResults toTestResult(@NotNull MochaSuiteTest test, @NotNull TestState state) {
        long durationInSeconds = TimeUnit.MILLISECONDS.toSeconds(test.getDuration());
        TestResults testResults = new TestResults(test.getFullTitle(), test.getTitle(), String.valueOf(durationInSeconds));
        testResults.setState(state);
        if (TestState.FAILED.equals((Object)state)) {
            testResults.addError((TestCaseResultError)new TestCaseResultErrorImpl(test.getError()));
        }
        return testResults;
    }
}

