/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.nodejs.tasks.bower;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.nodejs.tasks.AbstractNodeRequiringTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BowerConfigurator
extends AbstractNodeRequiringTaskConfigurator {
    private static final Logger log = Logger.getLogger(BowerConfigurator.class);
    public static final String BOWER_DEFAULT_EXECUTABLE = Joiner.on((String)File.separator).join((Object)"node_modules", (Object)"bower", new Object[]{"bin", "bower"});
    public static final String BOWER_RUNTIME = "bowerRuntime";
    public static final String COMMAND = "command";
    protected static final Set<String> FIELDS_TO_COPY = ImmutableSet.builder().addAll(AbstractNodeRequiringTaskConfigurator.FIELDS_TO_COPY).add((Object)"bowerRuntime").add((Object)"command").build();
    protected static final Map<String, Object> DEFAULT_FIELD_VALUES = ImmutableMap.builder().putAll(AbstractNodeRequiringTaskConfigurator.DEFAULT_FIELD_VALUES).put((Object)"bowerRuntime", (Object)BOWER_DEFAULT_EXECUTABLE).put((Object)"command", (Object)"install").build();

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isBlank((CharSequence)params.getString(BOWER_RUNTIME))) {
            errorCollection.addError(BOWER_RUNTIME, this.i18nResolver.getText("bower.runtime.error.empty"));
        }
        if (StringUtils.isBlank((CharSequence)params.getString(COMMAND))) {
            errorCollection.addError(COMMAND, this.i18nResolver.getText("bower.command.error.empty"));
        }
    }

    @Override
    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition) {
        return ImmutableSet.builder().addAll(super.calculateRequirements(taskDefinition)).add((Object)new RequirementImpl("system.git.executable", true, ".*", true)).build();
    }

    @Override
    @NotNull
    public Set<String> getFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    @NotNull
    public Map<String, Object> getDefaultFieldValues() {
        return DEFAULT_FIELD_VALUES;
    }
}

