/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.validation;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.docker.RepositoryKey;
import com.atlassian.bamboo.plugins.docker.RepositoryKeys;
import com.atlassian.bamboo.plugins.docker.validation.ConfigValidator;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class PushConfigValidator
implements ConfigValidator {
    private I18nResolver i18nResolver;

    public PushConfigValidator(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        RepositoryKey repositoryKey = RepositoryKeys.parseKey(params.getString("pushRepository"));
        if ("hub".equals(params.getString("registryOption"))) {
            if (repositoryKey.getRegistry() != null) {
                errorCollection.addError("pushRepository", this.i18nResolver.getText("docker.push.repository.registry.error.notEmpty"));
            }
        } else if ("custom".equals(params.getString("registryOption")) && repositoryKey.getRegistry() == null) {
            errorCollection.addError("pushRepository", this.i18nResolver.getText("docker.push.repository.registry.error.empty"));
        }
        if (StringUtils.isBlank((CharSequence)repositoryKey.getRepository())) {
            errorCollection.addError("pushRepository", this.i18nResolver.getText("docker.repository.error.empty"));
        }
        if (StringUtils.isNotBlank((CharSequence)params.getString("username")) && params.getBoolean("changePassword") && StringUtils.isBlank((CharSequence)params.getString("password"))) {
            errorCollection.addError("password", this.i18nResolver.getText("docker.password.error.empty"));
        }
    }
}

