/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.validation;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.docker.RepositoryKey;
import com.atlassian.bamboo.plugins.docker.RepositoryKeys;
import com.atlassian.bamboo.plugins.docker.validation.ConfigValidator;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BuildConfigValidator
implements ConfigValidator {
    private I18nResolver i18nResolver;

    public BuildConfigValidator(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        RepositoryKey repositoryKey = RepositoryKeys.parseKey(params.getString("repository"));
        if (StringUtils.isBlank((CharSequence)repositoryKey.getRepository())) {
            errorCollection.addError("repository", this.i18nResolver.getText("docker.repository.error.empty"));
        }
        if ("inline".equals(params.getString("dockerfileOption")) && StringUtils.isBlank((CharSequence)params.getString("dockerfile"))) {
            errorCollection.addError("dockerfile", this.i18nResolver.getText("docker.dockerfile.error.empty"));
        }
        if (params.getBoolean("save") && StringUtils.isBlank((CharSequence)params.getString("filename"))) {
            errorCollection.addError("filename", this.i18nResolver.getText("docker.save.filename.error.empty"));
        }
    }
}

