/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.tasks.cli;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.docker.client.DockerCmd;
import com.atlassian.bamboo.plugins.docker.process.DockerTaskProcessService;
import com.atlassian.bamboo.plugins.docker.service.DockerService;
import com.atlassian.bamboo.plugins.docker.service.DockerServiceFactory;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class DockerCliTask
implements CommonTaskType {
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private final DockerServiceFactory serviceFactory;

    @Autowired
    public DockerCliTask(@ComponentImport ProcessService processService, @ComponentImport EnvironmentVariableAccessor environmentVariableAccessor, @ComponentImport CapabilityContext capabilityContext, DockerServiceFactory serviceFactory) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        this.serviceFactory = serviceFactory;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        String dockerPath = this.capabilityContext.getCapabilityValue("system.docker.executable");
        Map extraEnvironmentVariables = this.environmentVariableAccessor.splitEnvironmentAssignments((String)configurationMap.get((Object)"environmentVariables"), false);
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        DockerCmd docker = new DockerCmd(dockerPath, DockerTaskProcessService.builder(taskContext, taskResultBuilder, this.processService).environmentVariables(extraEnvironmentVariables).build());
        String dockerCommandOption = (String)configurationMap.get((Object)"commandOption");
        DockerService dockerService = this.serviceFactory.create(docker, dockerCommandOption);
        dockerService.execute(taskContext);
        return taskResultBuilder.build();
    }
}

