/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.process;

import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.fugue.Option;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

@Immutable
public class ProcessCommand {
    private final List<String> command;
    private final Option<String> mask;

    private ProcessCommand(@NotNull List<String> command, @NotNull Option<String> mask) {
        this.command = command;
        this.mask = mask;
    }

    @NotNull
    public List<String> getCommandList() {
        return this.command;
    }

    @NotNull
    public String getSafeCommandString() {
        String commandString = Joiner.on((char)' ').join(this.command);
        if (this.mask.isDefined()) {
            return PasswordMaskingUtils.mask((String)commandString, (String)((String)this.mask.get()));
        }
        return commandString;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProcessCommand)) {
            return false;
        }
        ProcessCommand pc = (ProcessCommand)o;
        return new EqualsBuilder().append(this.command, pc.command).append(this.mask, pc.mask).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(83, 23).append(this.command).append(this.mask).toHashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<String> commandListBuilder = ImmutableList.builder();
        private Option<String> mask = Option.none();

        public Builder add(String ... elements) {
            this.commandListBuilder.add((Object[])elements);
            return this;
        }

        public Builder addAll(Iterable<String> elements) {
            this.commandListBuilder.addAll(elements);
            return this;
        }

        public Builder mask(@NotNull String mask) {
            this.mask = Option.some((Object)mask);
            return this;
        }

        public ProcessCommand build() {
            return new ProcessCommand((List)this.commandListBuilder.build(), this.mask);
        }
    }
}

