/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.export;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.AbstractDockerRegistryTask;
import com.atlassian.bamboo.specs.builders.task.DockerPullImageTask;
import com.atlassian.bamboo.specs.builders.task.DockerPushImageTask;
import com.atlassian.bamboo.specs.model.task.docker.AbstractDockerTaskProperties;
import com.atlassian.bamboo.specs.model.task.docker.DockerRegistryTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class RegistryTaskExporter
implements TaskDefinitionExporter {
    private static final Set<String> ACCEPTABLE_COMMAND_OPTIONS = ImmutableSet.of((Object)"pull", (Object)"push");

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        DockerRegistryTaskProperties properties = (DockerRegistryTaskProperties)Narrow.downTo((Object)taskProperties, DockerRegistryTaskProperties.class);
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)("Don't now how to import " + taskProperties.getClass().getCanonicalName()));
        ImmutableMap.Builder config = ImmutableMap.builder();
        switch (properties.getRegistryType()) {
            case DOCKER_HUB: {
                config.put((Object)"registryOption", (Object)"hub");
                break;
            }
            case CUSTOM: {
                config.put((Object)"registryOption", (Object)"custom");
                break;
            }
            default: {
                throw new IllegalStateException("Couldn't import: " + taskProperties);
            }
        }
        switch (properties.getOperationType()) {
            case PUSH: {
                config.put((Object)"commandOption", (Object)"push");
                config.put((Object)"email", (Object)StringUtils.defaultString((String)properties.getEmail()));
                config.put((Object)"username", (Object)StringUtils.defaultString((String)properties.getUsername()));
                config.put((Object)"password", (Object)StringUtils.defaultString((String)properties.getPassword()));
                config.put((Object)"pushRepository", (Object)StringUtils.defaultString((String)properties.getImage()));
                break;
            }
            case PULL: {
                config.put((Object)"commandOption", (Object)"pull");
                config.put((Object)"pullEmail", (Object)StringUtils.defaultString((String)properties.getEmail()));
                config.put((Object)"pullUsername", (Object)StringUtils.defaultString((String)properties.getUsername()));
                config.put((Object)"pullPassword", (Object)StringUtils.defaultString((String)properties.getPassword()));
                config.put((Object)"pullRepository", (Object)StringUtils.defaultString((String)properties.getImage()));
                break;
            }
            default: {
                throw new IllegalStateException("Couldn't handle operation type: " + properties.getOperationType());
            }
        }
        config.put((Object)"environmentVariables", (Object)StringUtils.defaultString((String)properties.getEnvironmentVariables()));
        config.put((Object)"workingSubDirectory", (Object)StringUtils.defaultString((String)properties.getWorkingSubdirectory()));
        return config.build();
    }

    @NotNull
    public Task toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        if (this.isDockerRegistryTask(taskDefinition)) {
            Map config = taskDefinition.getConfiguration();
            switch (config.getOrDefault("commandOption", "")) {
                case "push": {
                    DockerPushImageTask pushTask = (DockerPushImageTask)((DockerPushImageTask)((DockerPushImageTask)new DockerPushImageTask().authentication(config.getOrDefault("username", ""), config.getOrDefault("password", ""), config.getOrDefault("email", ""))).environmentVariables(config.getOrDefault("environmentVariables", ""))).workingSubdirectory(config.getOrDefault("workingSubDirectory", ""));
                    return this.setDockerImage((AbstractDockerRegistryTask)pushTask, config.getOrDefault("registryOption", ""), config.getOrDefault("pushRepository", ""));
                }
                case "pull": {
                    DockerPullImageTask pullTask = (DockerPullImageTask)((DockerPullImageTask)((DockerPullImageTask)new DockerPullImageTask().dockerHubImage(config.getOrDefault("pullRepository", "")).authentication(config.getOrDefault("pullUsername", ""), config.getOrDefault("pullPassword", ""), config.getOrDefault("pullEmail", ""))).environmentVariables(config.getOrDefault("environmentVariables", ""))).workingSubdirectory(config.getOrDefault("workingSubDirectory", ""));
                    return this.setDockerImage((AbstractDockerRegistryTask)pullTask, config.getOrDefault("registryOption", ""), config.getOrDefault("pullRepository", ""));
                }
            }
            throw new IllegalStateException("Something went badly. Couldn't export.");
        }
        throw new IllegalArgumentException(String.format("Couldn't export task by id: %s and plugin key: %s", taskDefinition.getId(), taskDefinition.getPluginKey()));
    }

    @NotNull
    private Task setDockerImage(AbstractDockerRegistryTask task, String registryOption, String registry) {
        switch (registryOption) {
            case "hub": {
                return task.dockerHubImage(registry);
            }
            case "custom": {
                return task.customRegistryImage(registry);
            }
        }
        throw new IllegalStateException("Something went badly. Couldn't export.");
    }

    private boolean isDockerRegistryTask(@NotNull TaskDefinition taskDefinition) {
        return taskDefinition.getPluginKey().equals(AbstractDockerTaskProperties.MODULE_KEY.getCompleteModuleKey()) && ACCEPTABLE_COMMAND_OPTIONS.contains(taskDefinition.getConfiguration().get("commandOption"));
    }

    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        return Collections.emptyList();
    }
}

