/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.tasks.cli;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.ConfigurableSharedCredentialDepender;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugins.docker.tasks.DockerTaskPredicates;
import com.atlassian.bamboo.plugins.docker.validation.ConfigValidator;
import com.atlassian.bamboo.plugins.docker.validation.ConfigValidatorFactory;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskConfiguratorHelper;
import com.atlassian.bamboo.task.TaskContextHelperService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskPredicates;
import com.atlassian.bamboo.task.TaskRequirementSupport;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.predicates.text.TextPredicates;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCliTaskConfigurator
extends AbstractTaskConfigurator
implements TaskRequirementSupport,
ConfigurableSharedCredentialDepender {
    private static final Logger log = Logger.getLogger(DockerCliTaskConfigurator.class);
    public static final String DOCKER_CLI_TASK_KEY = "com.atlassian.bamboo.plugins.bamboo-docker-plugin:task.docker.cli";
    public static final String DOCKER_COMMAND_OPTIONS = "commandOptions";
    public static final String DOCKER_COMMAND_OPTION_BUILD = "build";
    public static final String DOCKER_COMMAND_OPTION_RUN = "run";
    public static final String DOCKER_COMMAND_OPTION_PUSH = "push";
    public static final String DOCKER_COMMAND_OPTION_PULL = "pull";
    public static final String DOCKER_COMMAND_OPTION = "commandOption";
    public static final String DOCKERFILE_OPTIONS = "dockerfileOptions";
    public static final String DOCKERFILE_OPTION_EXISTING = "existing";
    public static final String DOCKERFILE_OPTION_INLINE = "inline";
    public static final String DOCKERFILE_OPTION = "dockerfileOption";
    public static final String DOCKERFILE = "dockerfile";
    public static final String REPOSITORY = "repository";
    public static final String NOCACHE = "nocache";
    public static final String SAVE = "save";
    public static final String FILENAME = "filename";
    public static final String BUILD_OPTIONS = "buildOptions";
    public static final Set<String> BUILD_FIELD_KEYS = ImmutableSet.builder().add((Object)"dockerfileOption").add((Object)"dockerfile").add((Object)"repository").add((Object)"buildOptions").add((Object)"nocache").add((Object)"save").add((Object)"filename").build();
    public static final String DETACHED_CONTAINERS = "detachedContainers";
    public static final String IMAGE = "image";
    public static final String COMMAND = "command";
    public static final String NAME = "name";
    public static final String DETACH = "detach";
    public static final String LINK = "link";
    public static final String ENV_VARS = "envVars";
    public static final String ADDITIONAL_ARGS = "additionalArgs";
    public static final String WORK_DIR = "workDir";
    public static final String VOLUMES_INDICES = "volumesIndices";
    public static final String HOST_DIRECTORY_PREFIX = "hostDirectory_";
    public static final String CONTAINER_DATA_VOLUME_PREFIX = "containerDataVolume_";
    public static final String PORTS_INDICES = "portsIndices";
    public static final String CONTAINER_PORT_PREFIX = "containerPort_";
    public static final String HOST_PORT_PREFIX = "hostPort_";
    public static final String SERVICE_WAIT = "serviceWait";
    public static final String SERVICE_URL_PATTERN = "serviceUrlPattern";
    public static final String SERVICE_TIMEOUT = "serviceTimeout";
    private static final Set<String> RUN_FIELD_KEYS = ImmutableSet.builder().add((Object)"image").add((Object)"command").add((Object)"name").add((Object)"detach").add((Object)"link").add((Object)"envVars").add((Object)"workDir").add((Object)"additionalArgs").add((Object)"serviceWait").add((Object)"serviceUrlPattern").add((Object)"serviceTimeout").build();
    public static final String DEFAULT_CONTAINER_WORK_DIR = "/data";
    public static final String TASK_WORK_DIR_PLACEHOLDER = "${bamboo.working.directory}";
    public static final String SERVICE_URL_PORT_PLACEHOLDER = "${docker.port}";
    public static final String DEFAULT_CONTAINER_SERVICE_URL = "http://localhost:${docker.port}";
    public static final long DEFAULT_TIMEOUT_SECONDS = 120L;
    public static final Predicate<TaskDefinition> isDockerRunDetachedTask;
    private static final Predicate<String> isVolumeField;
    private static final Predicate<String> isPortField;
    public static final String REGISTRY_OPTIONS = "registryOptions";
    public static final String REGISTRY_OPTION_HUB = "hub";
    public static final String REGISTRY_OPTION_CUSTOM = "custom";
    public static final String PUSH_REPOSITORY = "pushRepository";
    public static final String REGISTRY_OPTION = "registryOption";
    public static final String USERNAME = "username";
    public static final String CHANGE_PASSWORD = "changePassword";
    public static final String PASSWORD = "password";
    public static final String PUSH_SHARED_CREDENTIALS_ID = "pushSharedCredentialsId";
    public static final String EMAIL = "email";
    public static final String PUSH_CREDENTIALS_SOURCE = "pushCredentialsSource";
    public static final String SHARED_CREDENTIALS_LIST = "sharedCredentials";
    public static final String NO_SHARED_CREDENTIALS = "noSharedCredentials";
    public static final String CREDENTIALS_SOURCES_LIST = "credentialsSources";
    private static final Set<String> PUSH_FIELD_KEYS;
    public static final String PULL_REPOSITORY = "pullRepository";
    public static final String PULL_REGISTRY_OPTION = "pullRegistryOption";
    public static final String PULL_USERNAME = "pullUsername";
    public static final String PULL_CHANGE_PASSWORD = "pullChangePassword";
    public static final String PULL_PASSWORD = "pullPassword";
    public static final String PULL_SHARED_CREDENTIALS_ID = "pullSharedCredentialsId";
    public static final String PULL_EMAIL = "pullEmail";
    public static final String PULL_CREDENTIALS_SOURCE = "pullCredentialsSource";
    private static final Set<String> PULL_FIELD_KEYS;
    private static final Set<String> FIELD_KEYS;
    public static final String CREDENTIALS_DOCKER_CFG = "DOCKER_CFG";
    public static final String CREDENTIALS_SOURCE_USER = "USER";
    public static final String CREDENTIALS_SOURCE_SHARED_CREDENTIALS = "SHARED_CREDENTIALS";
    private final CredentialsAccessor credentialsAccessor;
    private final ConfigValidatorFactory validatorFactory;
    private final I18nResolver i18nResolver;
    private final TaskContextHelperService taskContextHelper;

    @Inject
    public DockerCliTaskConfigurator(@BambooImport CredentialsAccessor credentialsAccessor, ConfigValidatorFactory validatorFactory, @ComponentImport I18nResolver i18nResolver, @BambooImport TaskContextHelperService taskContextHelper, @BambooImport TaskConfiguratorHelper taskConfiguratorHelper) {
        this.credentialsAccessor = credentialsAccessor;
        this.validatorFactory = validatorFactory;
        this.i18nResolver = i18nResolver;
        this.taskContextHelper = taskContextHelper;
        this.taskConfiguratorHelper = taskConfiguratorHelper;
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition) {
        return ImmutableSet.of((Object)new RequirementImpl("system.docker.executable", true, ".*"));
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map map = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(map, params, FIELD_KEYS);
        for (String key : Iterables.filter((Iterable)params.keySet(), isVolumeField)) {
            map.put(key, params.getString(key));
        }
        for (String key : Iterables.filter((Iterable)params.keySet(), isPortField)) {
            map.put(key, params.getString(key));
        }
        this.generateTaskConfigMapForTaskWithAuthentication(params, previousTaskDefinition, map, CHANGE_PASSWORD, PASSWORD, DOCKER_COMMAND_OPTION_PUSH, PUSH_CREDENTIALS_SOURCE, PUSH_SHARED_CREDENTIALS_ID, USERNAME, EMAIL);
        this.generateTaskConfigMapForTaskWithAuthentication(params, previousTaskDefinition, map, PULL_CHANGE_PASSWORD, PULL_PASSWORD, DOCKER_COMMAND_OPTION_PULL, PULL_CREDENTIALS_SOURCE, PULL_SHARED_CREDENTIALS_ID, PULL_USERNAME, PULL_EMAIL);
        return map;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(DOCKER_COMMAND_OPTIONS, this.getDockerCommandOptions());
        context.put(DOCKER_COMMAND_OPTION, DOCKER_COMMAND_OPTION_BUILD);
        context.put(DOCKERFILE_OPTIONS, this.getDockerfileOptions());
        context.put(DOCKERFILE_OPTION, DOCKERFILE_OPTION_INLINE);
        context.put(WORK_DIR, DEFAULT_CONTAINER_WORK_DIR);
        context.put(VOLUMES_INDICES, ImmutableList.of((Object)0));
        context.put("hostDirectory_0", TASK_WORK_DIR_PLACEHOLDER);
        context.put("containerDataVolume_0", DEFAULT_CONTAINER_WORK_DIR);
        context.put(PORTS_INDICES, Collections.EMPTY_LIST);
        context.put(SERVICE_URL_PATTERN, DEFAULT_CONTAINER_SERVICE_URL);
        context.put(SERVICE_TIMEOUT, 120L);
        List tasks = this.taskContextHelper.getTasks(context);
        context.put(DETACHED_CONTAINERS, ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)tasks, (Predicate)Predicates.and(isDockerRunDetachedTask, (Predicate)TaskPredicates.isFinalisingEqual((boolean)false))), (Function)new TaskDefinitionToNameFunction())));
        context.put(REGISTRY_OPTIONS, this.getRegistryOptions());
        context.put(REGISTRY_OPTION, REGISTRY_OPTION_HUB);
        context.put(PULL_REGISTRY_OPTION, REGISTRY_OPTION_HUB);
        this.populateSharedCredentialsData(context);
        context.put(PULL_CREDENTIALS_SOURCE, CREDENTIALS_DOCKER_CFG);
        context.put(PUSH_CREDENTIALS_SOURCE, CREDENTIALS_DOCKER_CFG);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map configuration = taskDefinition.getConfiguration();
        context.putAll(configuration);
        context.put(DOCKER_COMMAND_OPTIONS, this.getDockerCommandOptions());
        context.put(DOCKERFILE_OPTIONS, this.getDockerfileOptions());
        List tasks = this.taskContextHelper.getTasksBeforeTaskId(context, taskDefinition.getId());
        context.put(DETACHED_CONTAINERS, ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)tasks, isDockerRunDetachedTask), (Function)new TaskDefinitionToNameFunction())));
        context.put(VOLUMES_INDICES, this.generateVolumesList(taskDefinition));
        context.put(PORTS_INDICES, this.generatePortsList(taskDefinition));
        context.put(REGISTRY_OPTIONS, this.getRegistryOptions());
        if (!context.containsKey(PULL_REGISTRY_OPTION)) {
            context.put(PULL_REGISTRY_OPTION, REGISTRY_OPTION_HUB);
        }
        this.populateSharedCredentialsData(context);
        if (DockerCliTaskConfigurator.isSharedCredentialsSourceActive(PULL_SHARED_CREDENTIALS_ID, taskDefinition.getConfiguration())) {
            context.put(PULL_CREDENTIALS_SOURCE, CREDENTIALS_SOURCE_SHARED_CREDENTIALS);
        } else if (configuration.containsKey(PULL_USERNAME) || configuration.containsKey(PULL_PASSWORD)) {
            context.put(PULL_CREDENTIALS_SOURCE, CREDENTIALS_SOURCE_USER);
        } else {
            context.put(PULL_CREDENTIALS_SOURCE, CREDENTIALS_DOCKER_CFG);
        }
        if (DockerCliTaskConfigurator.isSharedCredentialsSourceActive(PUSH_SHARED_CREDENTIALS_ID, taskDefinition.getConfiguration())) {
            context.put(PUSH_CREDENTIALS_SOURCE, CREDENTIALS_SOURCE_SHARED_CREDENTIALS);
        } else if (context.containsKey(USERNAME) || context.containsKey(PASSWORD)) {
            context.put(PUSH_CREDENTIALS_SOURCE, CREDENTIALS_SOURCE_USER);
        } else {
            context.put(PUSH_CREDENTIALS_SOURCE, CREDENTIALS_DOCKER_CFG);
        }
    }

    @NotNull
    public Iterable<Long> getSharedCredentialIds(@NotNull Map<String, String> configuration) {
        for (Pair key : Arrays.asList(Pair.make((Object)DOCKER_COMMAND_OPTION_PULL, (Object)PULL_SHARED_CREDENTIALS_ID), Pair.make((Object)DOCKER_COMMAND_OPTION_PUSH, (Object)PUSH_SHARED_CREDENTIALS_ID))) {
            if (!configuration.getOrDefault(DOCKER_COMMAND_OPTION, "").equals(key.getFirst()) || !DockerCliTaskConfigurator.isSharedCredentialsSourceActive((String)key.getSecond(), configuration)) continue;
            try {
                long sharedCredentialsId = Long.parseLong(configuration.getOrDefault(key.getSecond(), "-1"));
                return Collections.singletonList(sharedCredentialsId);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return Collections.emptyList();
    }

    public static boolean isSharedCredentialsSourceActive(String fieldKey, Map<String, String> configuration) {
        String sharedCredentialsId = configuration.getOrDefault(fieldKey, "");
        return StringUtils.isNotBlank((CharSequence)sharedCredentialsId) && !"-1".equals(sharedCredentialsId);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        ConfigValidator validator = this.validatorFactory.create(params.getString(DOCKER_COMMAND_OPTION));
        validator.validate(params, errorCollection);
    }

    @NotNull
    private List<Pair<String, String>> getDockerCommandOptions() {
        return ImmutableList.of((Object)Pair.make((Object)DOCKER_COMMAND_OPTION_BUILD, (Object)this.i18nResolver.getText("docker.command.build")), (Object)Pair.make((Object)DOCKER_COMMAND_OPTION_RUN, (Object)this.i18nResolver.getText("docker.command.run")), (Object)Pair.make((Object)DOCKER_COMMAND_OPTION_PUSH, (Object)this.i18nResolver.getText("docker.command.push")), (Object)Pair.make((Object)DOCKER_COMMAND_OPTION_PULL, (Object)this.i18nResolver.getText("docker.command.pull")));
    }

    @NotNull
    private List<Pair<String, String>> getDockerfileOptions() {
        return ImmutableList.of((Object)Pair.make((Object)DOCKERFILE_OPTION_EXISTING, (Object)this.i18nResolver.getText("docker.dockerfile.existing")), (Object)Pair.make((Object)DOCKERFILE_OPTION_INLINE, (Object)this.i18nResolver.getText("docker.dockerfile.inline")));
    }

    private List<Integer> generateVolumesList(TaskDefinition taskDefinition) {
        ArrayList<Integer> volumesList = new ArrayList<Integer>();
        for (String key : Iterables.filter(taskDefinition.getConfiguration().keySet(), TextPredicates.startsWith((String)CONTAINER_DATA_VOLUME_PREFIX)::test)) {
            volumesList.add(Integer.valueOf(StringUtils.removeStart((String)key, (String)CONTAINER_DATA_VOLUME_PREFIX)));
        }
        return volumesList;
    }

    private List<Integer> generatePortsList(TaskDefinition taskDefinition) {
        ArrayList<Integer> portsList = new ArrayList<Integer>();
        for (String key : Iterables.filter(taskDefinition.getConfiguration().keySet(), TextPredicates.startsWith((String)CONTAINER_PORT_PREFIX)::test)) {
            portsList.add(Integer.valueOf(StringUtils.removeStart((String)key, (String)CONTAINER_PORT_PREFIX)));
        }
        return portsList;
    }

    @NotNull
    private List<Pair<String, String>> getRegistryOptions() {
        return ImmutableList.of((Object)Pair.make((Object)REGISTRY_OPTION_HUB, (Object)this.i18nResolver.getText("docker.registry.hub")), (Object)Pair.make((Object)REGISTRY_OPTION_CUSTOM, (Object)this.i18nResolver.getText("docker.registry.custom")));
    }

    private void populateSharedCredentialsData(@NotNull Map<String, Object> context) {
        List<Pair<String, String>> sharedCredentials = this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials");
        if (sharedCredentials.isEmpty()) {
            context.put(NO_SHARED_CREDENTIALS, true);
        } else {
            context.put(SHARED_CREDENTIALS_LIST, sharedCredentials);
        }
        context.put(CREDENTIALS_SOURCES_LIST, this.getCredentialsSource());
    }

    private Map<String, String> getCredentialsSource() {
        return ImmutableMap.of((Object)CREDENTIALS_DOCKER_CFG, (Object)this.i18nResolver.getText("docker.credentials.source.dockercfg"), (Object)CREDENTIALS_SOURCE_USER, (Object)this.i18nResolver.getText("docker.credentials.source.user"), (Object)CREDENTIALS_SOURCE_SHARED_CREDENTIALS, (Object)this.i18nResolver.getText("docker.credentials.source.shared_credentials"));
    }

    private List<Pair<String, String>> getSharedCredentials(@NotNull String pluginKey) {
        return BambooIterables.stream((Iterable)this.credentialsAccessor.getAllCredentials()).filter(credentialsData -> pluginKey.equals(credentialsData.getPluginKey())).map(credentials -> Pair.make((Object)String.valueOf(credentials.getId()), (Object)credentials.getName())).collect(Collectors.toList());
    }

    private void generateTaskConfigMapForTaskWithAuthentication(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition, Map<String, String> map, String changePasswordKey, String passwordKey, String expectedDockerCommand, String credentialsSource, String sharedCredentialsIdKey, String usernameKey, String emailKey) {
        if (!params.getBoolean(changePasswordKey) && previousTaskDefinition != null) {
            map.put(passwordKey, (String)previousTaskDefinition.getConfiguration().get(passwordKey));
        }
        if (expectedDockerCommand.equals(params.getString(DOCKER_COMMAND_OPTION, ""))) {
            switch (params.getString(credentialsSource, "")) {
                case "DOCKER_CFG": {
                    map.remove(sharedCredentialsIdKey);
                    map.remove(usernameKey);
                    map.remove(passwordKey);
                    map.remove(emailKey);
                    break;
                }
                case "USER": {
                    map.remove(sharedCredentialsIdKey);
                    break;
                }
                case "SHARED_CREDENTIALS": {
                    map.remove(usernameKey);
                    map.remove(passwordKey);
                    map.remove(emailKey);
                }
            }
        }
    }

    static {
        Predicate[] predicateArray = new Predicate[4];
        predicateArray[0] = BambooPluginUtils.pluginKeyEquals((String)DOCKER_CLI_TASK_KEY)::test;
        predicateArray[1] = DockerTaskPredicates.isConfigurationFieldEqual(DOCKER_COMMAND_OPTION, DOCKER_COMMAND_OPTION_RUN);
        predicateArray[2] = DockerTaskPredicates.isConfigurationFieldEqual(DETACH, true);
        predicateArray[3] = TaskPredicates.isTaskEnabled();
        isDockerRunDetachedTask = Predicates.and((Predicate[])predicateArray);
        isVolumeField = Predicates.or(TextPredicates.startsWith((String)CONTAINER_DATA_VOLUME_PREFIX)::test, TextPredicates.startsWith((String)HOST_DIRECTORY_PREFIX)::test);
        isPortField = Predicates.or(TextPredicates.startsWith((String)CONTAINER_PORT_PREFIX)::test, TextPredicates.startsWith((String)HOST_PORT_PREFIX)::test);
        PUSH_FIELD_KEYS = ImmutableSet.builder().add((Object)PUSH_REPOSITORY).add((Object)REGISTRY_OPTION).add((Object)USERNAME).add((Object)PASSWORD).add((Object)PUSH_SHARED_CREDENTIALS_ID).add((Object)PUSH_CREDENTIALS_SOURCE).add((Object)EMAIL).build();
        PULL_FIELD_KEYS = ImmutableSet.builder().add((Object)PULL_REPOSITORY).add((Object)PULL_REGISTRY_OPTION).add((Object)PULL_USERNAME).add((Object)PULL_PASSWORD).add((Object)PULL_EMAIL).add((Object)PULL_SHARED_CREDENTIALS_ID).add((Object)PULL_CREDENTIALS_SOURCE).build();
        FIELD_KEYS = ImmutableSet.builder().add((Object)DOCKER_COMMAND_OPTION).addAll(BUILD_FIELD_KEYS).addAll(RUN_FIELD_KEYS).addAll(PUSH_FIELD_KEYS).addAll(PULL_FIELD_KEYS).add((Object)"environmentVariables").add((Object)"workingSubDirectory").build();
    }

    private class TaskDefinitionToNameFunction
    implements Function<TaskDefinition, String> {
        private TaskDefinitionToNameFunction() {
        }

        public String apply(@NotNull TaskDefinition taskDefinition) {
            return (String)taskDefinition.getConfiguration().get(DockerCliTaskConfigurator.NAME);
        }
    }
}

