/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.export;

import com.atlassian.bamboo.plugins.docker.export.DockerTaskExporter;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.DockerRunContainerTask;
import com.atlassian.bamboo.specs.model.task.docker.AbstractDockerTaskProperties;
import com.atlassian.bamboo.specs.model.task.docker.DockerRunContainerTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class RunContainerTaskExporter
implements TaskDefinitionExporter {
    private static final Logger log = Logger.getLogger(DockerTaskExporter.class);

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        DockerRunContainerTaskProperties properties = (DockerRunContainerTaskProperties)Narrow.downTo((Object)taskProperties, DockerRunContainerTaskProperties.class);
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)("Couldn't import: " + taskProperties.getClass().getCanonicalName()));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"commandOption", (Object)"run");
        builder.put((Object)"image", (Object)properties.getImageName());
        builder.put((Object)"detach", (Object)String.valueOf(properties.isDetachedContainer()));
        builder.put((Object)"name", (Object)StringUtils.defaultString((String)properties.getContainerName()));
        builder.putAll(this.portMappingsToConfiguration(properties.getPortMappings()));
        builder.put((Object)"serviceWait", (Object)String.valueOf(properties.isWaitToStart()));
        builder.put((Object)"serviceUrlPattern", (Object)StringUtils.defaultString((String)properties.getServiceURLPattern()));
        builder.put((Object)"serviceTimeout", (Object)String.valueOf(properties.getServiceTimeout()));
        builder.put((Object)"link", (Object)String.valueOf(properties.isLinkToDetachedContainers()));
        builder.put((Object)"envVars", (Object)StringUtils.defaultString((String)properties.getContainerEnvironmentVariables()));
        builder.put((Object)"command", (Object)StringUtils.defaultString((String)properties.getContainerCommand()));
        builder.put((Object)"workDir", (Object)StringUtils.defaultString((String)properties.getContainerWorkingDirectory(), (String)"/data"));
        builder.put((Object)"additionalArgs", (Object)StringUtils.defaultString((String)properties.getAdditionalArguments()));
        builder.putAll(this.volumeMappingsToConfiguration(properties.getVolumeMappings()));
        builder.put((Object)"environmentVariables", (Object)StringUtils.defaultString((String)properties.getEnvironmentVariables()));
        builder.put((Object)"workingSubDirectory", (Object)StringUtils.defaultString((String)properties.getWorkingSubdirectory()));
        return builder.build();
    }

    private Map<String, String> volumeMappingsToConfiguration(Map<String, String> volumes) {
        HashMap<String, String> config = new HashMap<String, String>();
        int counter = 0;
        for (Map.Entry<String, String> volumeMapping : volumes.entrySet()) {
            config.put("hostDirectory_" + counter, volumeMapping.getKey());
            config.put("containerDataVolume_" + counter, volumeMapping.getValue());
            ++counter;
        }
        return config;
    }

    private Map<String, String> portMappingsToConfiguration(Map<Integer, Integer> portMappings) {
        HashMap<String, String> portMappingConfig = new HashMap<String, String>();
        int counter = 0;
        for (Map.Entry<Integer, Integer> portMapping : portMappings.entrySet()) {
            portMappingConfig.put("hostPort_" + counter, String.valueOf(portMapping.getKey()));
            portMappingConfig.put("containerPort_" + counter, String.valueOf(portMapping.getValue()));
            ++counter;
        }
        return portMappingConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Task toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        if (this.isDockerRunContainerTask(taskDefinition)) {
            Map configuration = taskDefinition.getConfiguration();
            DockerRunContainerTask task = new DockerRunContainerTask();
            task.imageName(configuration.getOrDefault("image", ""));
            task.detachContainer(Boolean.parseBoolean(configuration.getOrDefault("detach", "false")));
            task.containerName(configuration.getOrDefault("name", ""));
            task.clearPortMappings();
            for (Map.Entry<Integer, Integer> portMapping : this.configMapToPortMappings(taskDefinition.getConfiguration()).entrySet()) {
                task.appendPortMapping(portMapping.getKey().intValue(), portMapping.getValue().intValue());
            }
            task.waitToStart(Boolean.parseBoolean(configuration.getOrDefault("serviceWait", "false")));
            task.serviceURLPattern(configuration.getOrDefault("serviceUrlPattern", "http://localhost:${docker.port}"));
            long timeout = 120L;
            try {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)configuration.get("serviceTimeout")))) {
                    timeout = Long.parseLong((String)configuration.get("serviceTimeout"));
                }
            }
            catch (NumberFormatException ex) {
                log.warn((Object)String.format("Task by id: %d has invalid timeout configuration: '%s'. Assuming default value.", taskDefinition.getId(), configuration.get("serviceTimeout")));
                log.debug((Object)ex);
            }
            finally {
                task.serviceTimeoutInSeconds(timeout);
            }
            task.linkToDetachedContainers(Boolean.parseBoolean(configuration.getOrDefault("link", "false")));
            task.containerEnvironmentVariables(configuration.getOrDefault("envVars", ""));
            task.containerCommand(configuration.getOrDefault("command", ""));
            task.containerWorkingDirectory(configuration.getOrDefault("workDir", "/data"));
            task.additionalArguments(configuration.getOrDefault("additionalArgs", ""));
            task.clearVolumeMappings();
            for (Map.Entry<String, String> volumeMapping : this.configMapToVolumeMappings(taskDefinition.getConfiguration()).entrySet()) {
                task.appendVolumeMapping(volumeMapping.getKey(), volumeMapping.getValue());
            }
            task.environmentVariables(configuration.getOrDefault("environmentVariables", ""));
            task.workingSubdirectory(configuration.getOrDefault("workingSubDirectory", ""));
            return task;
        }
        throw new IllegalArgumentException(String.format("Couldn't export task by id: %s and plugin key: %s", taskDefinition.getId(), taskDefinition.getPluginKey()));
    }

    private Map<Integer, Integer> configMapToPortMappings(Map<String, String> configuration) {
        ImmutableMap.Builder portMappings = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            if (!entry.getKey().contains("hostPort_")) continue;
            try {
                String counter = entry.getKey().substring("hostPort_".length());
                int hostPort = Integer.parseInt(entry.getValue());
                int containerPort = Integer.parseInt(configuration.get("containerPort_" + counter));
                portMappings.put((Object)hostPort, (Object)containerPort);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"Docker Run Container task export. Invalid port mapping in configuration map. Ignoring entry", (Throwable)ex);
            }
        }
        return portMappings.build();
    }

    private Map<String, String> configMapToVolumeMappings(Map<String, String> configuration) {
        ImmutableMap.Builder volumeMappings = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            if (!entry.getKey().contains("hostDirectory_")) continue;
            String counter = entry.getKey().substring("hostDirectory_".length());
            String hostVolume = entry.getValue();
            String containerVolume = configuration.get("containerDataVolume_" + counter);
            volumeMappings.put((Object)hostVolume, (Object)containerVolume);
        }
        return volumeMappings.build();
    }

    private boolean isDockerRunContainerTask(@NotNull TaskDefinition taskDefinition) {
        return taskDefinition.getPluginKey().equals(AbstractDockerTaskProperties.MODULE_KEY.getCompleteModuleKey()) && "run".equals(taskDefinition.getConfiguration().get("commandOption"));
    }

    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        Optional job = taskValidationContext.getOwnerJob();
        if (job.isPresent()) {
            Set detachedContainersNames;
            DockerRunContainerTaskProperties properties = (DockerRunContainerTaskProperties)Narrow.downTo((Object)taskProperties, DockerRunContainerTaskProperties.class);
            if (properties != null && properties.isDetachedContainer() && (detachedContainersNames = ((JobProperties)job.get()).getTasks().stream().map(task -> (DockerRunContainerTaskProperties)Narrow.downTo((Object)task, DockerRunContainerTaskProperties.class)).filter(Objects::nonNull).filter(task -> task != properties).filter(DockerRunContainerTaskProperties::isDetachedContainer).map(DockerRunContainerTaskProperties::getContainerName).collect(Collectors.toSet())).contains(properties.getContainerName())) {
                return Collections.singletonList(new ValidationProblem(DockerRunContainerTaskProperties.VALIDATION_CONTEXT, String.format("Name '%s' is already assigned to a detached container in this job", properties.getContainerName())));
            }
        } else {
            log.info((Object)"Can't validate containers name since job properties is not present.");
        }
        return Collections.emptyList();
    }
}

