/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.docker.config;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.docker.DataVolume;
import com.atlassian.bamboo.docker.PortMapping;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.utils.predicates.text.TextPredicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfiguration {
    private final String image;
    private final String command;
    private final boolean runDetached;
    private final String name;
    private final PortMapping firstPort;
    private final List<PortMapping> ports;
    private final boolean link;
    private final List<DataVolume> volumes;
    private final String workDir;
    private final boolean waitForService;
    private final String serviceUrl;
    private final long serviceTimeout;
    private final String environmentVariables;
    private final String additionalArgs;

    @NotNull
    public static RunConfiguration fromContext(@NotNull CommonTaskContext taskContext) {
        return new RunConfiguration(taskContext);
    }

    private RunConfiguration(@NotNull CommonTaskContext taskContext) {
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        this.image = (String)configurationMap.get((Object)"image");
        this.command = (String)configurationMap.get((Object)"command");
        this.runDetached = configurationMap.getAsBoolean("detach");
        this.name = this.runDetached ? (String)configurationMap.get((Object)"name") : null;
        this.firstPort = this.runDetached ? this.getFirstPort(configurationMap) : null;
        this.ports = this.runDetached ? this.getPorts(configurationMap) : Collections.emptyList();
        this.link = configurationMap.getAsBoolean("link");
        this.volumes = this.getVolumes(configurationMap);
        this.workDir = (String)configurationMap.get((Object)"workDir");
        this.waitForService = this.runDetached && configurationMap.getAsBoolean("serviceWait");
        this.serviceUrl = (String)configurationMap.get((Object)"serviceUrlPattern");
        this.serviceTimeout = this.getServiceTimeout(configurationMap);
        this.environmentVariables = (String)configurationMap.get((Object)"envVars");
        this.additionalArgs = (String)configurationMap.get((Object)"additionalArgs");
    }

    @NotNull
    private List<DataVolume> getVolumes(@NotNull ConfigurationMap configurationMap) {
        ImmutableList.Builder volumes = ImmutableList.builder();
        for (String key : Iterables.filter((Iterable)configurationMap.keySet(), TextPredicates.startsWith((String)"containerDataVolume_")::test)) {
            String containerDataVolume = (String)configurationMap.get((Object)key);
            String indexString = key.substring("containerDataVolume_".length());
            String hostDirectory = StringUtils.trimToNull((String)((String)configurationMap.get((Object)("hostDirectory_" + indexString))));
            volumes.add((Object)new DataVolume(hostDirectory, containerDataVolume));
        }
        return volumes.build();
    }

    @Nullable
    private PortMapping getFirstPort(@NotNull ConfigurationMap configurationMap) {
        String containerPortString = (String)configurationMap.get((Object)"containerPort_0");
        if (containerPortString != null) {
            String hostPortString = (String)configurationMap.get((Object)"hostPort_0");
            Integer hostPort = hostPortString != null ? Ints.tryParse((String)hostPortString) : null;
            return new PortMapping(Ints.tryParse((String)containerPortString).intValue(), hostPort);
        }
        return null;
    }

    @NotNull
    private List<PortMapping> getPorts(@NotNull ConfigurationMap configurationMap) {
        ImmutableList.Builder ports = ImmutableList.builder();
        for (String key : Iterables.filter((Iterable)configurationMap.keySet(), TextPredicates.startsWith((String)"containerPort_")::test)) {
            Integer containerPort = Integer.parseInt((String)configurationMap.get((Object)key));
            String indexString = key.substring("containerPort_".length());
            String hostPortString = (String)configurationMap.get((Object)("hostPort_" + indexString));
            Integer hostPort = hostPortString != null ? Ints.tryParse((String)hostPortString) : null;
            ports.add((Object)new PortMapping(containerPort.intValue(), hostPort));
        }
        return ports.build();
    }

    private long getServiceTimeout(@NotNull ConfigurationMap configurationMap) {
        String serviceTimeout = (String)configurationMap.get((Object)"serviceTimeout");
        if (StringUtils.isBlank((CharSequence)serviceTimeout)) {
            return 120L;
        }
        return configurationMap.getAsLong("serviceTimeout");
    }

    public String getImage() {
        return this.image;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isRunDetached() {
        return this.runDetached;
    }

    public String getName() {
        return this.name;
    }

    public PortMapping getFirstPort() {
        return this.firstPort;
    }

    public List<PortMapping> getPorts() {
        return this.ports;
    }

    public boolean isLink() {
        return this.link;
    }

    public List<DataVolume> getVolumes() {
        return this.volumes;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public boolean isWaitForService() {
        return this.waitForService;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public long getServiceTimeout() {
        return this.serviceTimeout;
    }

    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public String getAdditionalArgs() {
        return this.additionalArgs;
    }
}

