/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.ClasspathKeyPairProvider;
import com.atlassian.bamboo.plugins.ssh.DefaultSshClientAndServerFactory;
import com.atlassian.bamboo.plugins.ssh.SshClientAndServerFactory;
import com.atlassian.bamboo.plugins.ssh.SshProxyCommand;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataProvider;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.AbstractUserAuthFactory;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.channel.ChannelSessionFactory;
import org.jetbrains.annotations.Nullable;

public class SshProxy
implements ProxyConnectionDataProvider {
    private static final Logger log = Logger.getLogger(SshProxy.class);
    private final SshClientAndServerFactory sshClientAndServerFactory;
    private Exception clientInitializationException = null;
    private final Map<String, ProxyConnectionData> proxyConnectionDataMap = new WeakHashMap<String, ProxyConnectionData>();
    private static final ResettableLazyReference<SshProxy> instance = new ResettableLazyReference<SshProxy>(){

        @Nullable
        protected SshProxy create() {
            SshProxy sshProxy = new SshProxy(DefaultSshClientAndServerFactory.INSTANCE).start();
            if (sshProxy != null) {
                log.info((Object)("Successfully started: " + sshProxy.getHost() + " -p " + sshProxy.getPort()));
            }
            return sshProxy;
        }
    };
    protected SshServer sshServer;
    protected SshClient sshClient;

    public SshProxy(SshClientAndServerFactory sshClientAndServerFactory) {
        this.sshClientAndServerFactory = sshClientAndServerFactory;
    }

    @Nullable
    public static SshProxy getRunningInstance() {
        return (SshProxy)instance.get();
    }

    @Nullable
    public SshProxy start() {
        return this.start((NamedFactory<Channel>)new ChannelSessionFactory());
    }

    @Nullable
    @VisibleForTesting
    public SshProxy start(NamedFactory<Channel> factory) {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            log.error((Object)"SshProxy: Bouncy Castle is not registered!");
            this.clientInitializationException = new RepositoryException("SshProxy couldn't register Bouncy Castle as a JCE provider. SshProxy probably won't be able to connect to remote SSH servers...");
        }
        try {
            this.sshClient = this.startSshClient();
        }
        catch (SecurityException e) {
            log.error((Object)"SshClient initialization failed", (Throwable)e);
            this.clientInitializationException = e;
        }
        this.sshServer = this.sshClientAndServerFactory.createSshServer();
        this.sshServer.setPort(0);
        this.sshServer.setHost("127.0.0.1");
        ClasspathKeyPairProvider keyPairProvider = new ClasspathKeyPairProvider();
        this.sshServer.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        this.sshServer.setUserAuthFactories(Arrays.asList(new NamedFactory[]{new ProxyUserAuthNoneFactory(), new ProxyUserAuthPasswordFactory()}));
        this.sshServer.setChannelFactories(Arrays.asList(factory));
        this.sshServer.setCommandFactory(this.createCommandFactory());
        try {
            this.sshServer.start();
        }
        catch (IOException e) {
            log.error((Object)"Failed to start ssh proxy server", (Throwable)e);
            this.sshClient.stop();
            return null;
        }
        log.info((Object)("Server started: " + this.sshServer.getHost() + " -p " + this.sshServer.getPort()));
        return this;
    }

    private SshClient startSshClient() {
        SshClient client = this.sshClientAndServerFactory.createSshClient();
        client.setCompressionFactories(Arrays.asList(BuiltinCompressions.delayedZlib, BuiltinCompressions.zlib, BuiltinCompressions.none));
        client.start();
        return client;
    }

    public void stop() {
        try {
            this.sshServer.stop(true);
        }
        catch (IOException e) {
            log.error((Object)"IO exception while stopping ssh server", (Throwable)e);
        }
        this.sshClient.stop();
        this.sshServer = null;
        this.sshClient = null;
        instance.reset();
    }

    public ProxyConnectionData getConnectionData(String proxyUserName) {
        return this.proxyConnectionDataMap.get(proxyUserName);
    }

    public void remove(String proxyUserName) {
        log.debug((Object)("Removing proxy user mapping: " + proxyUserName));
        this.proxyConnectionDataMap.remove(proxyUserName);
    }

    public void add(String proxyUserName, ProxyConnectionData data) {
        log.debug((Object)("Adding proxy user mapping: " + proxyUserName));
        this.proxyConnectionDataMap.put(proxyUserName, data);
    }

    protected CommandFactory createCommandFactory() {
        return new CommandFactory(){

            public Command createCommand(String command) {
                log.debug((Object)("Creating command: " + command));
                return new SshProxyCommand(SshProxy.this.sshClient, SshProxy.this, command);
            }
        };
    }

    public String getHost() {
        return this.sshServer.getHost();
    }

    public int getPort() {
        return this.sshServer.getPort();
    }

    public Exception getClientInitializationException() {
        return this.clientInitializationException;
    }

    private class ProxyUserAuthPasswordFactory
    extends AbstractUserAuthFactory {
        ProxyUserAuthPasswordFactory() {
            super("password");
        }

        public UserAuth create() {
            return new SshProxyUserAuth();
        }
    }

    private class ProxyUserAuthNoneFactory
    extends AbstractUserAuthFactory {
        ProxyUserAuthNoneFactory() {
            super("none");
        }

        public UserAuth create() {
            return new SshProxyUserAuth();
        }
    }

    private class SshProxyUserAuth
    extends AbstractUserAuth {
        SshProxyUserAuth() {
            super("Bamboo SshProxyUserAuth");
        }

        protected Boolean doAuth(Buffer buffer, boolean init) throws Exception {
            String username = this.getUsername();
            boolean found = SshProxy.this.getConnectionData(username) != null;
            log.debug((Object)("Authenticating proxy user " + username + " - " + (found ? "succeeded" : "FAILED")));
            if (found) {
                return true;
            }
            throw new Exception("Proxy user not found: " + username);
        }
    }
}

