/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.executor.RetryingTaskExecutor;
import com.atlassian.bamboo.plugins.ssh.SshConfig;
import com.atlassian.bamboo.plugins.ssh.SshMessageHandler;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataProvider;
import com.atlassian.bamboo.utils.RecentLazyReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.ChannelUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.jetbrains.annotations.Nullable;

public class SshProxyCommand
implements Command,
SshMessageHandler {
    private static final Logger log = Logger.getLogger(SshProxyCommand.class);
    private static final int SSH_CONNECTION_RETRIES = 3;
    private static final int INITIAL_SSH_RETRY_DELAY_MS = 1000;
    private final String command;
    private final ProxyConnectionDataProvider proxyConnectionDataProvider;
    private static RecentLazyReference<SshConfig> recentSshConfig = new RecentLazyReference<SshConfig>(60L, TimeUnit.SECONDS){

        protected SshConfig createInstance() throws Exception {
            SshConfig defaultSshConfig = SshConfig.getDefaultSshConfig();
            return defaultSshConfig;
        }
    };
    private OutputStream outputStream;
    private InputStream inputStream;
    private OutputStream errorStream;
    private ExitCallback exitCallback;
    private SshClient client;
    private ClientSession session;
    private ProxyConnectionData connectionData;
    private ChannelExec channel;

    public SshProxyCommand(SshClient client, ProxyConnectionDataProvider proxyConnectionDataProvider, String command) {
        this.client = client;
        this.command = command;
        this.proxyConnectionDataProvider = proxyConnectionDataProvider;
    }

    public void setInputStream(InputStream in) {
        this.inputStream = in;
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
    }

    public void setErrorStream(OutputStream err) {
        this.errorStream = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.exitCallback = callback;
    }

    public void start(Environment env) throws IOException {
        log.debug((Object)("Start called: " + env.getEnv().toString()));
        String proxyUserName = (String)env.getEnv().get("USER");
        if (proxyUserName == null) {
            String msg = "Expected USER to be set: " + env.getEnv().toString();
            log.error((Object)msg);
            this.writeToErrorStream(msg);
            this.exitCallback.onExit(255);
            return;
        }
        ProxyConnectionData suppliedConnectionData = this.proxyConnectionDataProvider.getConnectionData(proxyUserName);
        if (suppliedConnectionData == null) {
            String msg = "Cannot map user to connection data: " + proxyUserName;
            log.error((Object)msg);
            this.writeToErrorStream(msg);
            this.exitCallback.onExit(255);
            return;
        }
        SshConfig sshConfig = (SshConfig)recentSshConfig.get();
        this.connectionData = sshConfig.apply(suppliedConnectionData, SystemUtils.USER_NAME);
        new Thread("Connection monitoring thread - " + proxyUserName){

            @Override
            public void run() {
                Callable<Object> startConnectionTask = new Callable<Object>(){

                    @Override
                    @Nullable
                    public Object call() throws Exception {
                        SshProxyCommand.this.startRemoteConnection();
                        return null;
                    }
                };
                try {
                    String taskDescription = "Connecting to " + SshProxyCommand.this.connectionData.getConnectionDescription();
                    Predicate isIllegalStateException = Predicates.instanceOf(IllegalStateException.class);
                    RetryingTaskExecutor.retry((String)taskDescription, (int)3, (long)1000L, (Callable)startConnectionTask, (Predicate)isIllegalStateException);
                }
                catch (Exception e) {
                    SshProxyCommand.this.finishWithError("Error while opening SSH session", e);
                }
            }
        }.start();
    }

    public void destroy() {
        log.debug((Object)"Destroy called");
        new Thread("Connection killer"){

            @Override
            public void run() {
                SshProxyCommand.this.closeSession();
            }
        }.start();
    }

    private synchronized void startRemoteConnection() {
        ConnectFuture connectFuture;
        log.debug((Object)"Connecting client");
        try {
            connectFuture = this.client.connect(this.connectionData.getRemoteAddress());
        }
        catch (Exception e) {
            this.finishWithError("Remote connection failed", e);
            return;
        }
        this.session = ((ConnectFuture)connectFuture.awaitUninterruptibly()).getSession();
        if (!connectFuture.isConnected()) {
            this.finishWithError("Can't connect session, connectFuture is not connected...", connectFuture.getException());
            return;
        }
        this.connectSession();
    }

    private void connectSession() {
        AuthFuture authFuture;
        try {
            KeyPair keyPair = this.connectionData.getKeyPair();
            if (keyPair == null) {
                String remotePassword = this.connectionData.getRemotePassword();
                Preconditions.checkNotNull((Object)remotePassword);
                log.debug((Object)("Authenticating user [" + this.connectionData.getRemoteUserName() + "] using a password"));
                authFuture = this.session.authPassword(this.connectionData.getRemoteUserName(), remotePassword);
            } else {
                Preconditions.checkNotNull((Object)keyPair);
                log.debug((Object)("Authenticating user [" + this.connectionData.getRemoteUserName() + "] using a key pair"));
                authFuture = this.session.authPublicKey(this.connectionData.getRemoteUserName(), keyPair);
            }
        }
        catch (IOException e) {
            this.finishWithError("I/O exception during authentication of the remote session", e);
            return;
        }
        authFuture.awaitUninterruptibly();
        if (authFuture.isSuccess()) {
            this.createExecChannel();
        } else {
            this.finishWithError("Authenticating remote session failed", authFuture.getException());
        }
    }

    private void createExecChannel() {
        OpenFuture openFuture;
        log.debug((Object)"Creating exec channel");
        try {
            this.channel = this.session.createExecChannel(this.mapPaths(this.command));
        }
        catch (Exception e) {
            this.finishWithError("Error creating exec channel", e);
            return;
        }
        this.channel.setIn(this.inputStream);
        this.channel.setErr(this.errorStream);
        this.channel.setOut(this.outputStream);
        try {
            openFuture = this.channel.open();
        }
        catch (Exception e) {
            this.finishWithError("Error opening exec channel", e);
            return;
        }
        openFuture.awaitUninterruptibly();
        if (openFuture.isOpened()) {
            int ret = this.channel.waitFor(3, 0L);
            log.debug((Object)("Session wait: " + ret));
            this.finishCleanly();
        } else {
            this.finishWithError("Error opening exec channel", openFuture.getException());
        }
    }

    private String mapPaths(String command) {
        if (this.connectionData.getMapPathFrom() != null) {
            String replacement;
            String toReplace = "'" + this.connectionData.getMapPathFrom() + "'";
            String commandWithPathsReplaced = command.replaceAll(toReplace, replacement = "'" + this.connectionData.getMapPathTo() + "'");
            if (commandWithPathsReplaced.equals(command)) {
                if (command.contains(replacement)) {
                    log.info((Object)("Already replaced " + command));
                } else {
                    log.warn((Object)("Did not replace anything in " + command));
                }
            } else {
                log.debug((Object)("Replaced paths from: " + command + " to " + commandWithPathsReplaced));
            }
            return commandWithPathsReplaced;
        }
        return command;
    }

    synchronized void closeSession() {
        log.debug((Object)"Closing session");
        if (this.session != null) {
            this.session.close(true);
            this.session = null;
        }
    }

    private void finishCleanly() {
        log.debug((Object)"Connection finished");
        this.closeSession();
        this.exitCallback.onExit(0);
    }

    private void finishWithError(String msg, Throwable t) {
        this.connectionData.reportProxyError(msg, t);
        StringBuilder sb = new StringBuilder("While connecting to [").append(this.connectionData.getRemoteUserName()).append("@").append(this.connectionData.getRemoteAddress()).append("]: ").append(msg);
        String logMessage = sb.toString();
        log.warn((Object)logMessage, t);
        String errorMessage = t == null ? logMessage : sb.append(": ").append(t.getMessage()).toString();
        this.writeToErrorStream(errorMessage);
        this.exitCallback.onExit(255);
        this.closeSession();
    }

    private void writeToErrorStream(String errorMessage) {
        try {
            this.errorStream.write("BAMBOO-SSH-PROXY: [".getBytes());
            this.errorStream.write(errorMessage.getBytes());
            this.errorStream.write("]\n".getBytes());
            this.errorStream.flush();
        }
        catch (IOException e) {
            log.warn((Object)"Cannot write error message to the client", (Throwable)e);
        }
    }

    @Override
    public void onEof() throws IOException {
        ChannelUtils.sendEof((AbstractChannel)this.channel);
    }

    @Override
    public void onClose() {
        ChannelUtils.close((Channel)this.channel);
    }
}

