/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.PlainTextPasswordFinder;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataBuilder;
import com.atlassian.bamboo.ssh.ProxyErrorReceiver;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Preconditions;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyPair;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyConnectionDataBuilderImpl
implements ProxyConnectionDataBuilder {
    private static final Logger log = Logger.getLogger(ProxyConnectionDataBuilderImpl.class);
    private String remoteUserName;
    private KeyPair keyPair;
    private ProxyErrorReceiver proxyErrorReceiver;
    private String remotePassword;
    private String mapPathFrom;
    private String mapPathTo;
    private String connectionDescription;
    private String host;
    private Integer port;

    public ProxyConnectionDataBuilderImpl withRemoteUserName(String name) {
        this.remoteUserName = name;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withKeyFromFile(String filePath, @Nullable String passphrase) {
        FileKeyPairProvider keyPairProvider = new FileKeyPairProvider(new String[]{filePath}, (PasswordFinder)new PlainTextPasswordFinder(passphrase));
        try {
            return this.load(keyPairProvider);
        }
        catch (RuntimeException e) {
            String passPhraseStatus = StringUtils.isEmpty((String)passphrase) ? "not used" : "used";
            String msg = "Unable to load key from file [" + filePath + "], passphrase " + passPhraseStatus;
            log.error((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    public ProxyConnectionDataBuilderImpl withKeyFromString(String key, @Nullable String passphrase) throws IOException {
        return this.withKeyFromReader(new CharArrayReader(key.toCharArray()), passphrase);
    }

    public ProxyConnectionDataBuilderImpl withRemotePathMapping(@NotNull String from, @NotNull String to) {
        this.mapPathFrom = from;
        this.mapPathTo = to;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withConnectionDescription(@Nullable String connectionDescription) {
        this.connectionDescription = connectionDescription;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyConnectionDataBuilderImpl withKeyFromReader(Reader keyReader, @Nullable String passphrase) throws IOException {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IOException("Couldn't register Bouncy Castle as a JCE provider. Private key cannot be read");
        }
        PEMReader pemReader = new PEMReader(keyReader, (PasswordFinder)new PlainTextPasswordFinder(passphrase));
        try {
            this.keyPair = (KeyPair)pemReader.readObject();
        }
        finally {
            pemReader.close();
        }
        return this;
    }

    public ProxyConnectionDataBuilderImpl withKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    private ProxyConnectionDataBuilderImpl load(FileKeyPairProvider keyPairProvider) {
        KeyPair[] keyPairs = keyPairProvider.loadKeys();
        Preconditions.checkArgument((keyPairs.length != 0 ? 1 : 0) != 0, (Object)"The supplied key is not in a supported format or needs a passphrase to be decrypted");
        this.keyPair = keyPairs[0];
        return this;
    }

    public ProxyConnectionDataBuilderImpl withRemoteHost(@Nullable String host) {
        this.host = host;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withRemotePort(@Nullable Integer port) {
        this.port = port;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withErrorReceiver(ProxyErrorReceiver receiver) {
        this.proxyErrorReceiver = receiver;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withRemotePassword(String password) {
        this.remotePassword = password;
        return this;
    }

    public ProxyConnectionData build() {
        return new ProxyConnectionData(){
            private final LazyReference<SocketAddress> remoteAddress = new LazyReference<SocketAddress>(){

                protected SocketAddress create() throws Exception {
                    return new InetSocketAddress(ProxyConnectionDataBuilderImpl.this.host, (int)ProxyConnectionDataBuilderImpl.this.port);
                }
            };

            public String getMapPathFrom() {
                return ProxyConnectionDataBuilderImpl.this.mapPathFrom;
            }

            public String getMapPathTo() {
                return ProxyConnectionDataBuilderImpl.this.mapPathTo;
            }

            public SocketAddress getRemoteAddress() {
                return (SocketAddress)this.remoteAddress.get();
            }

            public Integer getRemotePort() {
                return ProxyConnectionDataBuilderImpl.this.port;
            }

            public String getRemoteHost() {
                return ProxyConnectionDataBuilderImpl.this.host;
            }

            public String getRemoteUserName() {
                return ProxyConnectionDataBuilderImpl.this.remoteUserName;
            }

            public KeyPair getKeyPair() {
                return ProxyConnectionDataBuilderImpl.this.keyPair;
            }

            public String getConnectionDescription() {
                return ProxyConnectionDataBuilderImpl.this.connectionDescription;
            }

            public String getRemotePassword() {
                return ProxyConnectionDataBuilderImpl.this.remotePassword;
            }

            public void reportProxyError(String message, Throwable exception) {
                if (ProxyConnectionDataBuilderImpl.this.proxyErrorReceiver != null) {
                    ProxyConnectionDataBuilderImpl.this.proxyErrorReceiver.reportProxyError(message, exception);
                }
            }

            public ProxyErrorReceiver getErrorReceiver() {
                return ProxyConnectionDataBuilderImpl.this.proxyErrorReceiver;
            }
        };
    }

    public ProxyConnectionDataBuilder withProxyConnectionData(ProxyConnectionData connectionData) {
        this.withRemoteHost(connectionData.getRemoteHost()).withRemotePort(connectionData.getRemotePort()).withRemoteUserName(connectionData.getRemoteUserName()).withKeyPair(connectionData.getKeyPair()).withRemotePassword(connectionData.getRemotePassword()).withConnectionDescription(connectionData.getConnectionDescription()).withErrorReceiver(connectionData.getErrorReceiver());
        if (connectionData.getMapPathFrom() != null && connectionData.getMapPathTo() != null) {
            this.withRemotePathMapping(connectionData.getMapPathFrom(), connectionData.getMapPathTo());
        }
        return this;
    }
}

