/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.ClasspathKeyPairProvider;
import com.atlassian.bamboo.plugins.ssh.ProxyChannelSession;
import com.atlassian.bamboo.plugins.ssh.SshClientBackport;
import com.atlassian.bamboo.plugins.ssh.SshProxyCommand;
import com.atlassian.bamboo.plugins.ssh.SshServerBackport;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataProvider;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.sshd.SshClient;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.UserAuthNone;
import org.apache.sshd.server.auth.UserAuthPassword;
import org.apache.sshd.server.session.ServerSession;
import org.jetbrains.annotations.Nullable;

public class SshProxy
implements ProxyConnectionDataProvider {
    private static final Logger log = Logger.getLogger(SshProxy.class);
    private Exception clientInitializationException = null;
    private final Map<String, ProxyConnectionData> proxyConnectionDataMap = new WeakHashMap<String, ProxyConnectionData>();
    private final File defaultKnownHostsFile;
    private static ResettableLazyReference<SshProxy> instance = new ResettableLazyReference<SshProxy>(){

        protected SshProxy create() {
            SshProxy sshProxy = new SshProxy().start();
            if (sshProxy != null) {
                log.info((Object)("Successfully started: " + sshProxy.sshServer.getHost() + " -p " + sshProxy.sshServer.getPort()));
            }
            return sshProxy;
        }
    };
    protected SshServer sshServer;
    private SshClient sshClient;

    public SshProxy() {
        this(new File(new File(new File(System.getProperty("user.home")), ".ssh"), "known_hosts"));
    }

    protected SshProxy(File defaultKnownHostsFile) {
        this.defaultKnownHostsFile = defaultKnownHostsFile;
    }

    @Nullable
    public static SshProxy getRunningInstance() {
        return (SshProxy)instance.get();
    }

    @Nullable
    public SshProxy start() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            log.error((Object)"SshProxy: Bouncy Castle is not registered!");
            this.clientInitializationException = new RepositoryException("SshProxy couldn't register Bouncy Castle as a JCE provider. SshProxy probably won't be able to connect to remote SSH servers...");
        }
        try {
            this.sshClient = SshClientBackport.setUpDefaultClient();
            this.sshClient.start();
        }
        catch (SecurityException e) {
            log.error((Object)"SshClient initialization failed", (Throwable)e);
            this.clientInitializationException = e;
        }
        this.sshServer = SshServerBackport.setUpDefaultServer();
        this.sshServer.setPort(0);
        this.sshServer.setHost("127.0.0.1");
        ClasspathKeyPairProvider keyPairProvider = new ClasspathKeyPairProvider();
        this.sshServer.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        String keyKnownHostsLine = keyPairProvider.getKeyKnownHostsLine();
        this.addKnownHostsLine(keyKnownHostsLine);
        this.sshServer.setUserAuthFactories(Arrays.asList(new NamedFactory[]{new ProxyUserAuthNoneFactory(), new ProxyUserAuthPasswordFactory()}));
        this.sshServer.setChannelFactories(Arrays.asList(new ProxyChannelSession.Factory()));
        this.sshServer.setCommandFactory(this.createCommandFactory());
        try {
            this.sshServer.start();
        }
        catch (IOException e) {
            log.error((Object)"Failed to start ssh proxy server", (Throwable)e);
            this.sshClient.stop();
            return null;
        }
        log.info((Object)("Server started: " + this.sshServer.getHost() + " -p " + this.sshServer.getPort()));
        return this;
    }

    public void stop() {
        try {
            this.sshServer.stop(true);
        }
        catch (InterruptedException e) {
            log.error((Object)"Uninterruptible operation interrupted", (Throwable)e);
        }
        this.sshClient.stop();
        this.sshServer = null;
        this.sshClient = null;
        instance.reset();
    }

    public ProxyConnectionData getConnectionData(String proxyUserName) {
        return this.proxyConnectionDataMap.get(proxyUserName);
    }

    public void remove(String proxyUserName) {
        log.debug((Object)("Removing proxy user mapping: " + proxyUserName));
        this.proxyConnectionDataMap.remove(proxyUserName);
    }

    public void add(String proxyUserName, ProxyConnectionData data) {
        log.debug((Object)("Adding proxy user mapping: " + proxyUserName));
        this.proxyConnectionDataMap.put(proxyUserName, data);
    }

    protected CommandFactory createCommandFactory() {
        return new CommandFactory(){

            public Command createCommand(String command) {
                log.debug((Object)("Creating command: " + command));
                return new SshProxyCommand(SshProxy.this.sshClient, SshProxy.this, command);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addKnownHostsLine(String line) {
        block12: {
            block10: {
                FileInputStream inputStream;
                block9: {
                    if (!this.defaultKnownHostsFile.getParentFile().exists() && !this.defaultKnownHostsFile.getParentFile().mkdirs()) {
                        log.error((Object)("Cannot create parent dir for known_hosts file " + this.defaultKnownHostsFile));
                        return;
                    }
                    if (!this.defaultKnownHostsFile.exists()) break block10;
                    inputStream = null;
                    try {
                        inputStream = new FileInputStream(this.defaultKnownHostsFile);
                        List lines = IOUtils.readLines((InputStream)inputStream);
                        if (!lines.contains(line)) break block9;
                    }
                    catch (IOException e) {
                        try {
                            log.warn((Object)("Cannot read known_hosts file " + this.defaultKnownHostsFile), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inputStream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                    return;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                log.info((Object)("Adding '" + line + "' to existing file " + this.defaultKnownHostsFile.getAbsolutePath()));
                break block12;
            }
            log.info((Object)("Adding '" + line + "' to new file " + this.defaultKnownHostsFile.getAbsolutePath()));
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(this.defaultKnownHostsFile, true));
            writer.println(line);
        }
        catch (IOException e) {
            try {
                log.warn((Object)("Cannot write to known_hosts file " + this.defaultKnownHostsFile), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public String getHost() {
        return this.sshServer.getHost();
    }

    public int getPort() {
        return this.sshServer.getPort();
    }

    File getKnownHostsFileLocation() {
        return this.defaultKnownHostsFile;
    }

    public Exception getClientInitializationException() {
        return this.clientInitializationException;
    }

    private class ProxyUserAuthPasswordFactory
    extends UserAuthPassword.Factory {
        private ProxyUserAuthPasswordFactory() {
        }

        public UserAuth create() {
            return new SshProxyUserAuth();
        }
    }

    private class ProxyUserAuthNoneFactory
    extends UserAuthNone.Factory {
        private ProxyUserAuthNoneFactory() {
        }

        public UserAuth create() {
            return new SshProxyUserAuth();
        }
    }

    private class SshProxyUserAuth
    implements UserAuth {
        private SshProxyUserAuth() {
        }

        public Boolean auth(ServerSession session, String username, Buffer buffer) throws Exception {
            boolean found = SshProxy.this.getConnectionData(username) != null;
            log.debug((Object)("Authenticating user " + username + " - " + (found ? "succeeded" : "FAILED")));
            if (found) {
                return true;
            }
            throw new Exception("Proxy user not found: " + username);
        }
    }
}

