/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class StreamCopyThread
extends Thread {
    private static final int BUFFER_SIZE = 1024;
    private final InputStream src;
    private final OutputStream dst;
    private volatile boolean done;

    public StreamCopyThread(InputStream i, OutputStream o) {
        this.setName(Thread.currentThread().getName() + "-StreamCopy");
        this.src = i;
        this.dst = o;
    }

    public void flush() {
        this.interrupt();
    }

    public void halt() throws InterruptedException {
        while (true) {
            this.join(250L);
            if (!this.isAlive()) break;
            this.done = true;
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] buf = new byte[1024];
            int interruptCounter = 0;
            try {
                while (true) {
                    int n;
                    if (interruptCounter > 0) {
                        this.dst.flush();
                        --interruptCounter;
                    }
                    if (this.done) break;
                    try {
                        n = this.src.read(buf);
                    }
                    catch (InterruptedIOException wakey) {
                        ++interruptCounter;
                        continue;
                    }
                    if (n >= 0) {
                        boolean writeInterrupted = false;
                        while (true) {
                            try {
                                this.dst.write(buf, 0, n);
                            }
                            catch (InterruptedIOException wakey) {
                                writeInterrupted = true;
                                continue;
                            }
                            break;
                        }
                        if (!writeInterrupted) continue;
                        this.interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                this.src.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.dst.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.src.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.dst.close();
        }
        catch (IOException e) {}
    }
}

