/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;

public class EolCanonicalizingInputStream
extends InputStream {
    private final byte[] single = new byte[1];
    private final byte[] buf = new byte[8096];
    private final InputStream in;
    private int cnt;
    private int ptr;

    public EolCanonicalizingInputStream(InputStream in) {
        this.in = in;
    }

    public int read() throws IOException {
        int read = this.read(this.single, 0, 1);
        return read == 1 ? this.single[0] & 0xFF : -1;
    }

    public int read(byte[] bs, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.cnt == -1) {
            return -1;
        }
        int startOff = off;
        int end = off + len;
        while (off < end && (this.ptr != this.cnt || this.fillBuffer())) {
            byte b;
            if ((b = this.buf[this.ptr++]) != 13) {
                bs[off++] = b;
                continue;
            }
            if (this.ptr == this.cnt && !this.fillBuffer()) {
                bs[off++] = 13;
                break;
            }
            if (this.buf[this.ptr] == 10) {
                bs[off++] = 10;
                ++this.ptr;
                continue;
            }
            bs[off++] = 13;
        }
        return startOff == off ? -1 : off - startOff;
    }

    public void close() throws IOException {
        this.in.close();
    }

    private boolean fillBuffer() throws IOException {
        this.cnt = this.in.read(this.buf, 0, this.buf.length);
        if (this.cnt < 1) {
            return false;
        }
        this.ptr = 0;
        return true;
    }
}

