/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.treewalk.TreeWalk;
import org.shaded.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.shaded.eclipse.jgit.treewalk.filter.TreeFilter;

public class NotIgnoredFilter
extends TreeFilter {
    private final int index;

    public NotIgnoredFilter(int workdirTreeIndex) {
        this.index = workdirTreeIndex;
    }

    public boolean include(TreeWalk tw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        WorkingTreeIterator i = tw.getTree(this.index, WorkingTreeIterator.class);
        return i == null || !i.isEntryIgnored();
    }

    public boolean shouldBeRecursive() {
        return false;
    }

    public TreeFilter clone() {
        return this;
    }

    public String toString() {
        return "NotIgnored(" + this.index + ")";
    }
}

