/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.lib;

import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.Ref;

public class SymbolicRef
implements Ref {
    private final String name;
    private final Ref target;

    public SymbolicRef(String refName, Ref target) {
        this.name = refName;
        this.target = target;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSymbolic() {
        return true;
    }

    public Ref getLeaf() {
        Ref dst = this.getTarget();
        while (dst.isSymbolic()) {
            dst = dst.getTarget();
        }
        return dst;
    }

    public Ref getTarget() {
        return this.target;
    }

    public ObjectId getObjectId() {
        return this.getLeaf().getObjectId();
    }

    public Ref.Storage getStorage() {
        return Ref.Storage.LOOSE;
    }

    public ObjectId getPeeledObjectId() {
        return this.getLeaf().getPeeledObjectId();
    }

    public boolean isPeeled() {
        return this.getLeaf().isPeeled();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("SymbolicRef[");
        Ref cur = this;
        while (cur.isSymbolic()) {
            r.append(cur.getName());
            r.append(" -> ");
            cur = cur.getTarget();
        }
        r.append(cur.getName());
        r.append('=');
        r.append(ObjectId.toString(cur.getObjectId()));
        r.append("]");
        return r.toString();
    }
}

