/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.transport.JschConfigSessionFactory;
import org.shaded.eclipse.jgit.transport.OpenSshConfig;
import org.shaded.eclipse.jgit.util.FS;

public class GitSshSessionFactory
extends JschConfigSessionFactory {
    private final String key;
    private final String passphrase;

    GitSshSessionFactory(@Nullable String key, @Nullable String passphrase) {
        this.key = key;
        this.passphrase = passphrase;
    }

    @Override
    protected void configure(OpenSshConfig.Host hc, Session session) {
        session.setConfig("StrictHostKeyChecking", "no");
    }

    @Override
    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        JSch jsch = super.getJSch(hc, fs);
        jsch.removeAllIdentity();
        if (StringUtils.isNotEmpty((String)this.key)) {
            jsch.addIdentity("identityName", this.key.getBytes(), null, this.passphrase.getBytes());
        }
        return jsch;
    }
}

