/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials.api.service;

import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentials;
import com.atlassian.bamboo.plugins.aws.credentials.AwsCredentialsService;
import com.atlassian.bamboo.plugins.aws.credentials.api.LinkHelper;
import com.atlassian.bamboo.plugins.aws.credentials.api.RestConstants;
import com.atlassian.bamboo.plugins.aws.credentials.api.model.RestAwsCredentials;
import com.atlassian.bamboo.plugins.aws.credentials.api.service.RestAwsCredentialsService;
import org.jetbrains.annotations.NotNull;

public class RestAwsCredentialsServiceImpl
implements RestAwsCredentialsService {
    private final AwsCredentialsService awsCredentialsService;
    private final LinkHelper linkHelper;

    public RestAwsCredentialsServiceImpl(AwsCredentialsService awsCredentialsService, LinkHelper linkHelper) {
        this.awsCredentialsService = awsCredentialsService;
        this.linkHelper = linkHelper;
    }

    @Override
    public RestAwsCredentials addCredentials(@NotNull RestAwsCredentials restAwsCredentials) throws WebValidationException {
        String name = restAwsCredentials.getName();
        String accessKey = restAwsCredentials.getAccessKey();
        String secretKey = restAwsCredentials.getSecretKey();
        AwsCredentials credentials = this.awsCredentialsService.createCredentials(name, accessKey, secretKey);
        return this.toRestAwsCredentials(credentials);
    }

    @Override
    public RestAwsCredentials updateCredentials(long credentialsId, @NotNull RestAwsCredentials restAwsCredentials) throws WebValidationException {
        String name = restAwsCredentials.getName();
        String accessKey = restAwsCredentials.getAccessKey();
        String secretKey = restAwsCredentials.getSecretKey();
        AwsCredentials credentials = this.awsCredentialsService.updateCredentials(credentialsId, name, accessKey, secretKey);
        return this.toRestAwsCredentials(credentials);
    }

    @Override
    public RestAwsCredentials getCredentials(long credentialsId) {
        AwsCredentials credentials = this.awsCredentialsService.getCredentials(credentialsId);
        return this.toRestAwsCredentials(credentials);
    }

    @Override
    public void deleteCredentials(long credentialsId) {
        this.awsCredentialsService.deleteCredentials(credentialsId);
    }

    @NotNull
    private RestAwsCredentials toRestAwsCredentials(@NotNull AwsCredentials credentials) {
        RestAwsCredentials restAwsCredentials = (RestAwsCredentials)((Object)RestAwsCredentials.FROM_AWS_CREDENTIALS.apply((Object)credentials));
        this.linkHelper.addLinks(restAwsCredentials, String.format(RestConstants.CREDENTIALS_URL, credentials.getId()));
        return restAwsCredentials;
    }
}

