/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials.api;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.bamboo.plugins.aws.core.AwsException;
import com.atlassian.bamboo.plugins.aws.credentials.api.model.RestS3Bucket;
import com.atlassian.bamboo.plugins.aws.credentials.api.service.RestS3Service;
import com.atlassian.bamboo.rest.model.ListResponse;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="credentials/{credentialsId}/s3")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ExperimentalApi
public class S3Resource {
    public static final List<RestS3Bucket> S3_BUCKETS_EXAMPLE = new ArrayList<RestS3Bucket>();
    private final RestS3Service restS3Service;

    public S3Resource(RestS3Service restS3Service) {
        this.restS3Service = restS3Service;
    }

    @GET
    @Path(value="buckets")
    public Response getBuckets(@PathParam(value="credentialsId") long credentialsId) throws AwsException {
        ListResponse<RestS3Bucket> buckets = this.restS3Service.getBuckets(credentialsId);
        return Response.ok(buckets).build();
    }

    static {
        S3_BUCKETS_EXAMPLE.add(new RestS3Bucket("code-deploy-bucket"));
    }
}

