/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials.api;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.bamboo.plugins.aws.core.AwsException;
import com.atlassian.bamboo.plugins.aws.credentials.api.model.RestCodeDeployApplication;
import com.atlassian.bamboo.plugins.aws.credentials.api.model.RestCodeDeployDeploymentGroup;
import com.atlassian.bamboo.plugins.aws.credentials.api.service.RestCodeDeployService;
import com.atlassian.bamboo.rest.model.ListResponse;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="credentials/{credentialsId}/regions/{regionName}/codedeploy")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ExperimentalApi
public class CodeDeployResource {
    public static final List<RestCodeDeployApplication> CODEDEPLOY_APPLICATIONS_EXAMPLE = new ArrayList<RestCodeDeployApplication>();
    public static final List<RestCodeDeployDeploymentGroup> CODEDEPLOY_DEPLOYMENT_GROUPS_EXAMPLE = new ArrayList<RestCodeDeployDeploymentGroup>();
    private final RestCodeDeployService restCodeDeployService;

    public CodeDeployResource(RestCodeDeployService restCodeDeployService) {
        this.restCodeDeployService = restCodeDeployService;
    }

    @GET
    @Path(value="applications")
    public Response getApplications(@PathParam(value="credentialsId") long credentialsId, @PathParam(value="regionName") String regionName) throws AwsException {
        ListResponse<RestCodeDeployApplication> applications = this.restCodeDeployService.getApplications(credentialsId, regionName);
        return Response.ok(applications).build();
    }

    @GET
    @Path(value="applications/{applicationName}/deploymentGroups")
    public Response getDeploymentGroups(@PathParam(value="credentialsId") long credentialsId, @PathParam(value="regionName") String regionName, @PathParam(value="applicationName") String applicationName) throws AwsException {
        ListResponse<RestCodeDeployDeploymentGroup> deploymentGroups = this.restCodeDeployService.getDeploymentGroups(credentialsId, regionName, applicationName);
        return Response.ok(deploymentGroups).build();
    }

    static {
        CODEDEPLOY_APPLICATIONS_EXAMPLE.add(new RestCodeDeployApplication("Bamboo"));
        CODEDEPLOY_DEPLOYMENT_GROUPS_EXAMPLE.add(new RestCodeDeployDeploymentGroup("Staging"));
    }
}

