/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.credentials;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.atlassian.bamboo.credentials.CredentialTypeExporter;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.plugins.aws.core.AwsException;
import com.atlassian.bamboo.plugins.aws.core.iam.IdentityManagementService;
import com.atlassian.bamboo.plugins.aws.credentials.Constants;
import com.atlassian.bamboo.plugins.aws.credentials.entities.AwsCredentials;
import com.atlassian.bamboo.plugins.aws.credentials.entities.AwsCredentialsProperties;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentials;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class AwsCredentialTypeExporter
implements CredentialTypeExporter {
    private static final Logger log = Logger.getLogger(AwsCredentialTypeExporter.class);
    @Autowired
    private I18nResolver i18nResolver;
    @Autowired
    private IdentityManagementService iamService;

    @NotNull
    public SharedCredentials toSpecsEntity(@NotNull CredentialsData credentialsData) {
        Map cfg = credentialsData.getConfiguration();
        return new AwsCredentials().withAccessKey((String)cfg.get(Constants.CFG_ACCESS_KEY)).withSecretKey((String)cfg.get(Constants.CFG_SECRET_KEY));
    }

    public Map<String, String> toCredentialsConfiguration(SharedCredentialsProperties entityProperties) throws YamlValidationException {
        AwsCredentialsProperties props = (AwsCredentialsProperties)entityProperties;
        try {
            String error = this.iamService.getAccountValidationError((AWSCredentials)new BasicAWSCredentials(props.getAccessKey(), props.getSecretKey()));
            if (!StringUtils.isBlank((CharSequence)error)) {
                throw new PropertiesValidationException(this.i18nResolver.getText("aws.credentials.invalid", new Serializable[]{error}));
            }
        }
        catch (AwsException e) {
            log.warn((Object)this.i18nResolver.getText("aws.credentials.error"), (Throwable)e);
            throw new PropertiesValidationException(this.i18nResolver.getText("aws.credentials.error"));
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put(Constants.CFG_ACCESS_KEY, props.getAccessKey());
        result.put(Constants.CFG_SECRET_KEY, props.getSecretKey());
        return result;
    }
}

