define('credentials/dialog-form-add-credentials', [
    'jquery',
    'underscore',
    'widget/dialog-form',
    'widget/dialog',
    'util/ajax',
    'util/ajax-form'
], function(
    $,
    _,
    DialogForm,
    Dialog,
    ajax,
    AjaxForm
) {

    'use strict';

    var DialogFormAddCredentials = DialogForm.extend({

        /**
         * Local template used only for MoveFormDialog.
         */
        template: bamboo.plugins.aws.dialog.form.add.credentials,

        defaultSettings: {
            buttons: [{
                id: 'save',
                label: AJS.I18n.getText('aws.codedeploy.credentials.save'),
                cssClass: 'aui-button aui-button-primary'
            }, {
                id: 'cancel',
                label: AJS.I18n.getText('aws.codedeploy.credentials.cancel'),
                type: 'link'
            }],
            header: AJS.I18n.getText('aws.codedeploy.credentials.add.title'),
            width: 550,
            height: 400
        },

        /**
         * Initialize form & dialog settings
         * and fetches delete warnings.
         */
        initialize: function(options) {
            var settings = options || {};
            settings.content = this.template.form();
            DialogForm.prototype.initialize.call(this, settings);
        },

        /**
         * Override onCreateInstance, to execute
         * custom logic after dialog is created.
         */
        onCreateInstance: function() {
            Dialog.prototype.onCreateInstance.apply(this, arguments);

            var $form = this.dialog.getPage(0).body.find('form');
            this.form = new AjaxForm($form, {
                url: $form.attr('action'),
                type: $form.attr('method')
            });
            this.form.bind(this.formSettings);

            // events are bind at the end
            // (form.bind removes any previous defined)
            this.form
                .on('error', _.bind(this.onFormError, this))
                .on('submit', _.bind(this.onFormSubmit, this))
                .on('success', _.bind(this.onFormSuccess, this));
        },

        /**
         * On success close current dialog.
         */
        onFormSuccess: function(evt, result) {
            $(this.settings.$credentialsEl).append($("<option />", {
                val: result.id,
                text: result.name
            })).val(result.id).trigger('change');

            DialogForm.prototype.onFormSuccess.call(this);
        }

    });

    return DialogFormAddCredentials;

});
